/*==================================================================
 * sample.h - Header file for sample interface routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <smurf@resonance.org>
 * Smurf homepage: http://www.resonance.org/smurf/
 *==================================================================*/
#ifndef __SAMPLE_H__
#define __SAMPLE_H__

#include "config.h"

#include <glib.h>
#include "sfont.h"

#ifndef WITH_AUDIOFILE
#include <sndfile.h>
#else
#include <audiofile.h>
#endif

/* since entire samples are operated on, we limit the max size of samples */
#define MAX_SAMPLE_SIZE		8*1024*1024

enum AudioFileType
{ AUDIO_TYPE_UNKNOWN, AUDIO_TYPE_RAW, AUDIO_TYPE_WAV,
  AUDIO_TYPE_AIFF, AUDIO_TYPE_AU
};

enum AudioInstFlags
{
  AUDIO_INST_NODATA   = 0,

  AUDIO_INST_LOOP     = 1 << 0,
  AUDIO_INST_ROOTNOTE = 1 << 1,
  AUDIO_INST_FINETUNE = 1 << 2
};

typedef struct _AudioInfo
{
  enum AudioFileType filetype;
  guint frames;
  guint rate;
  guint channels;
  guint width;
  gboolean lendian;
  gboolean signd;

  enum AudioInstFlags instdata;	/* available instrument data flags */
  guint loopstart;		/* start of loop */
  guint loopend;		/* end of loop */
  guint rootnote;		/* sample MIDI root note # */
  guint finetune;		/* sample fine tuning in cents */
} AudioInfo;

#ifndef WITH_AUDIOFILE
typedef struct _AudioFileRef
{
  SNDFILE *afh;
  AudioInfo info;
}
AudioFileRef;
#else
typedef struct _AudioFileRef
{
  AFfilehandle afh;
  AudioInfo info;
}
AudioFileRef;
#endif

FILE *sambuf_fd;
gint sambuf_pos;

SFSample *sam_in_view;
gint16 *sam_data_in_view;
GSList *sam_datainfo_list;

#define SAM_DATAINFO_REFCOUNT(datainfo)  (datainfo->refcount + datainfo->dorefcount)

int sam_buf_init (void);
void sam_buf_destroy (void);
SFSamDataInfo *sam_datainfo_new (void);
void sam_datainfo_destroy (SFSamDataInfo *datainfo);
gint sam_datainfo_move2sambuf (SFSample *sam, SFData *sf);
gpointer sam_load_sample (SFSample * sam, gint size, gint ofs,
			  gpointer bufptr);
SFSample * sam_create_sample (gchar *name, gint rate, gint16 *samdata,
  gint size, SFData *sf);
SFSample *sam_clone_sample (SFData * dst, SFData * src, SFSample * sam);
gint sam_cut_sample (SFData * sf, SFSample * sam, guint spos, guint epos);
SFSample *sam_load_file_as_sample (AudioFileRef * afref, SFData * sf);
gint sam_check_file (AudioFileRef * afref);
gint sam_export_sample (SFSample * sam, SFData * sf, gchar * fname,
  enum AudioFileType filetype);
AudioFileRef *sam_open_file (gchar * fname, gboolean read, AudioInfo * afmt);
gint sam_read_file (AudioFileRef * afref, void *buf, gint count);
gint sam_write_file (AudioFileRef * afref, void *buf, gint count);
void sam_close_file (AudioFileRef * afref);

#endif /* __SAMPLE_H__ */
