/*==================================================================
 * wtbl_awe.h - Header file for OSS AWE wavetable driver routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __WTBL_AWE_H__
#define __WTBL_AWE_H__

#include "config.h"

#ifdef AWE_SUPPORT

#include <glib.h>
#include "sfont.h"

gboolean awe_new_api;

/* awe sequencer routines */
gint awe_init (void);
void awe_set_effect (gint chan, guint16 genid, SFGenAmount amt);

/* patch routines */
gint awe_open_patch (gboolean locksamples);
gint awe_close_patch (void);
gint awe_load_sample (SFSample * sam, SFData * sf);
gint awe_load_patch_info (gint bank, gint prenum, SFGenAmount *gens,
			  SFSample *sam, SFData *sf, gboolean replace);
gint awe_clear_samples (void);
gint awe_clear_unlocked_samples (void);
void awe_clear_sample_patch_id (SFSample *sam, gboolean locked);

/* memory management routines */
gint awe_mem_avail (void);
gint awe_samdata_mem_required (SFSample *sam, SFData *sf, gboolean usecache,
			       gboolean locked);


#endif /* #ifdef AWE_SUPPORT */

#endif	/* __WTBL_AWE_H__ */
