/*
SMS Server Tools
Copyright (C) 2000 Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:s.frings@mail.isis.de
*/

#ifndef SMSD_CFG_H
#define SMSD_CFG_H

#define PROVIDER 16 
#define DEVICES 16
#define NUMS 16

typedef struct 
{ 
  char name[32]; 		// Name of the queue
  char numbers[NUMS][16];	// Phone numbers assigned to this queue
  char directory[256];		// Queue directory
} _queue;

typedef struct
{
  char name[32];		// Name of the modem
  char device[256];		// Serial port name
  char queues[PROVIDER][32];	// Assigned queues
  int incoming; 		// Try to receive SMS 0 or 1
  int report; 			// Ask for delivery report 0 or 1 (experimental state)
  char pin[16];			// SIM PIN
  char mode[10]; 		// Command set version  old, new oder ascii
  char smsc[16];		// Number of SMSC
  int baudrate;			// Baudrate
  int cs_convert; 		// Convert character set  0 or 1 (iso-9660)
  char initstring[32];		// additional Init String
  char eventhandler[256];	// event handler program or script
} _device;

int debug;			// 1 if debug mode (do not really send and do not delete received SM
char configfile[256];		// Path to config file
char mypath[256];		// Path to binaries
char d_spool[256];		// Spool directory
char d_failed[256];		// Failed spool directory
char d_incoming[256];		// Incoming spool directory
char d_sent[256];		// Sent spool directory
char eventhandler[256];		// Global event handler program or script
char logfile[256];		// Name or Handle of Log File
int  loglevel;			// Log Level (9=highest). Verbosity of log file.
_queue queues[PROVIDER];	// Queues
_device devices[DEVICES];	// Modem devices
int rejected_counter;		// Statistic counter, rejected SM, number does not fit into any queue
int delaytime;			// sleep-time after workless
int blocktime;			// sleep-time after multiple errors
int errorsleeptime;		// sleep-time after each error

/* initialize all variable with default values */

void initcfg();


/* read the config file */

void readcfg();


/* show all config data for debug purpose */

void printcfg();


/* Retuns the array-index and the directory of a queue or -1 if
   not found. Name is the name of the queue or a phone number. */

int getqueue(char* name, char* directory);


/* Returns the array-index of a device or -1 if not found */

int getdevice(char* name);


/* Show help */

void help();

/* parse arguments */

void parsearguments(int argc,char** argv);

#endif
