#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <regex.h>
#include "sms.h"
#include "debug.h"

//int WyslijSMS(const char *telefon, const char *wiadomosc, sms_func gsm, const char *ok_msg, int nsplit, int max_len)
int WyslijSMS(sms_func gsm, SMS_packet *sms)
  /* wysyla sms'a dzielac go w razie potrzeby na
   * sms'y po max_len dlugosci
   * pewnie mozna to lepiej napisac, ale nie mialem czasu :)
   *
   * zwroci 0 jesli jakikolwiek sms udalo sie wyslac (dostanie sie
   * potwierdzenie od serwera)
   */
{
	char *wiadomosc = sms->wiadomosc;
	int nsplit = sms->nsplit;
	int max_len = sms->max_len;
	SMS_packet tmp_sms;
	tmp_sms.telefon = sms->telefon;
	tmp_sms.potwierdzenie = sms->potwierdzenie;
  char buffor[2048], pakiet[2048], wyraz[2048];
  int len = strlen(wiadomosc);
  int wyslane = 0, ilosc, przeczytane = 0, ret_val = 0;
  /* 
   * wyslane - ile pakietow wiadomosci zostalo wyslane,
   * ilosc - ile sms'ow trzeba wyslac,
   * przeczytane - ile znakow wiadomosci przeczytane
   */
  char *naglowek = "<sms %i z %i>: ";
  int nlen = strlen(naglowek);

  strncpy(buffor, wiadomosc, sizeof(buffor)-1);
  buffor[sizeof(buffor)-1] = 0;
  memset(pakiet,0,sizeof(pakiet));

  /* wiadomosc trzeba podzielic */
  ilosc = len / (max_len - nlen);
  if (ilosc * (max_len - nlen) < len) ilosc++;
  if (ilosc > nsplit) ilosc = nsplit;
  if (ilosc > 1)
      debug_stream->Log(LOG_INFO, "Sms ma wiecej niz %i znakow, wiec dziele go na %i czesci",max_len,ilosc);

  if (ilosc > 1) {

    while(wyslane < ilosc) {
      /* wysylanie sms'ow pakietmi */
      if (strlen(buffor) > 0) {
	sscanf(buffor,"%s",wyraz); /* czytamy jeden wyraz */
	if (strlen(wyraz) > max_len) {
	  /* jeden wyraz ma wiecej niz max_len znakow */
	  debug_stream->Log(LOG_WARN,"Blad! Za duzy wyraz w wiadomosci, ucinam (%s)", wyraz);
	  exit(1);
	}
	if (((strlen(pakiet)+strlen(wyraz) + nlen) > max_len) || !strlen(buffor) ) {
	  /* wysylam czesc wiadomosci */
	  sprintf(buffor,naglowek,wyslane + 1, ilosc);
	  strcat(buffor,pakiet);
	  strcpy(pakiet,buffor);
	  /* naglowek dodany, mozna wysylac */
	  //printf("pakiet: %s (%i)\n",pakiet, strlen(pakiet));
	  tmp_sms.wiadomosc = pakiet;
	  ret_val |= gsm(&tmp_sms);
	  debug_stream->Log(LOG_INFO,"sms %i z %i wyslany",wyslane+1, ilosc);
	  wyslane++;
	  memset(pakiet,0,sizeof(pakiet));
	}
	przeczytane = przeczytane + strlen(wyraz);
	strcat(pakiet,wyraz);
	//	printf("pakiet -> %s\n",pakiet);
	strcpy(buffor,wiadomosc+przeczytane);
	strcat(pakiet," "); przeczytane++;
      }
      else {
	/* ostatni pakiet wiadomosci */
	sprintf(buffor,naglowek,wyslane + 1, ilosc);
	strcat(buffor,pakiet);
	strcpy(pakiet,buffor);
	//printf("pakiet: %s (%i)\n",pakiet, strlen(pakiet));
	tmp_sms.wiadomosc = pakiet;
	ret_val |= gsm(&tmp_sms);
	debug_stream->Log(LOG_INFO,"sms %i z %i wyslany",wyslane+1, ilosc);
	wyslane++;
      }       
    }
  }
  else {
    /* cala wiadomosc sir miesci */
    //printf("pakiet: %s\n",wiadomosc);
    strncpy(buffor, wiadomosc, sizeof(buffor)-1);
    buffor[max_len] = 0;
	tmp_sms.wiadomosc = buffor;
    ret_val |= gsm(&tmp_sms);
  }

  return !ret_val;
}

int poprawna_odpowiedz(const char *ok, const char *numer, const char *body)
{
	char buf[200];
	regex_t preg;
	regmatch_t reg;
	int wynik;

	// formatujemy wiadomosc otrzymana od serwera. w miejsce znaku %s
	// wstawiamy 9-cio cyfrowy numer telefonu, bez prefiksu kraju
	sprintf(buf, ok, numer);

	regcomp(&preg, buf, 0);
	wynik = !regexec(&preg, body, 1, &reg, 0);
	regfree(&preg);

	debug_stream->Log(LOG_INFO, "Szukam potwierdzenia '%s', wynik: %d", buf, wynik);

	return wynik;
}

