/*
 * dvpump.cc -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include "DVPumpProvider.h"
#include <unistd.h>


/** DVPumpProvider implementation - covers a multitude of sins :-). The pump 
 	thread is terminated when the abstract ReadFrame implementation returns 
	false.
*/

DVPumpProvider::DVPumpProvider( ) :
	blockable( false )
{
};

/** The thread reads until no input is available or the thread is terminated.
*/

void DVPumpProvider::Thread( )
{
	bool running = true;

	while( running && ThreadIsRunning( ) )
	{
		if ( GetInputAvailable( ) > 0 )
		{
			Frame &frame = GetInputFrame( );
			if ( ReadFrame( frame ) )
			{
				QueueOutputFrame( );
			}
			else
			{
				Diagnostics::Log( *this, "Input ended" );
				running = false;
			}
		}
	}
	ClearPump( );
}

/** Provide blockabily over ride at this level.
*/

void DVPumpProvider::SetBlockable( bool _blockable )
{
	blockable = _blockable;
}

/** Indicates if this instance is blockable.
*/

bool DVPumpProvider::IsBlockable( )
{
	return blockable;
}

/** Get the speed of playback.
*/

double DVPumpProvider::GetSpeed( )
{
	return IsPaused( ) ? 0.0 : 1.0;
}

/** Seek and set the speed.
*/

bool DVPumpProvider::Seek( int position, double speed )
{
	return false;
}
