/***************************************************************************
                          smb4kbrowseractionmenu  -  description
                             -------------------
    begin                : So Feb 19 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBROWSERACTIONMENU_H
#define SMB4KBROWSERACTIONMENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <kactionclasses.h>
#include <kactioncollection.h>
#include <kaction.h>

/**
 * This class provides an action menu for the use with the browser widget
 * of the main application, the Konqueror plugin or other widgets.
 *
 * NOTE: The actions are not connected to any slots nor are they added to a group.
 * They are also not disabled. You have to implement all of that in the widget were
 * you incorporate this menu!
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KBrowserActionMenu : public KActionMenu
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param design          The design of the menu. It is determined by the Design enumeration.
     *
     * @param collection      The action collection that the actions of the action menu
     *                        should belong to.
     *
     * @param text            The text for this action menu.
     *
     * @param icon            The icon set for this menu.
     *
     * @param parent          The parent widget of this menu.
     *
     * @param name            The name of this menu.
     */
    Smb4KBrowserActionMenu( int design, KActionCollection *collection, const QString &text = QString::null, const QIconSet &icon = QIconSet(), QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     *
     * ATTENTION: The actions in the menu will *NOT* be deleted here. You *MUST* delete them
     * in the widget where you implemented the menu!
     */
    ~Smb4KBrowserActionMenu();

    /**
     * Enumeration to determine how the menu should be designed.
     *
     * 'Full' means, all actions and separators are shown. This is for use with the
     * browser widget, where you need all actions.
     *
     * 'KonqPlugin' shows a specialized menu widget (less actions).
     */
    enum Design{ Full, KonqPlugin };

    /**
     * This function returns a pointer to the rescan action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the rescan action or NULL if not .
     */
    KAction *rescanAction() { return m_rescan_action; }

    /**
     * This function returns a pointer to the abort action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the abort action.
     */
    KAction *abortAction() { return m_abort_action; }

    /**
     * This function returns a pointer to the askpass action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the askpass action.
     */
    KAction *askpassAction() { return m_askpass_action; }

    /**
     * This function returns a pointer to the preview action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the preview action.
     */
    KAction *previewAction() { return m_preview_action; }

    /**
     * This function returns a pointer to the bookmark action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the bookmark action.
     */
    KAction *bookmarkAction() { return m_bookmark_action; }

    /**
     * This function returns a pointer to the print action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the print action.
     */
    KAction *printAction() { return m_print_action; }

    /**
     * This function returns a pointer to the mount action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the mount action.
     */
    KAction *mountAction() { return m_mount_action; }

    /**
     * This function returns a pointer to the search action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the search action.
     */
    KAction *searchAction() { return m_search_action; }

    /**
     * This function returns a pointer to the manual mount action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     *
     * @returns               A pointer to the manual mount action.
     */
    KAction *manualMountAction() { return m_manual_action; }

    /**
     * This function sets the title of the menu widget.
     *
     * @param title           The text for the title.
     */

  private:
    /**
     * This is the action collection for this action menu.
     */
    KActionCollection *m_collection;

    /**
     * This function sets up the action menu.
     *
     * @param design          The design of the menu.
     */
    void setupMenu( int design );

    /**
     * The preview action.
     */
    KAction *m_preview_action;

    /**
     * The askpass action.
     */
    KAction *m_askpass_action;

    /**
     * The print action.
     */
    KAction *m_print_action;

    /**
     * The mount action.
     */
    KAction *m_mount_action;

    /**
     * The bookmark action.
     */
    KAction *m_bookmark_action;

    /**
     * The rescan action.
     */
    KAction *m_rescan_action;

    /**
     * The abort action.
     */
    KAction *m_abort_action;

    /**
     * The search action.
     */
    KAction *m_search_action;

    /**
     * This action invokes the mount dialog.
     */
    KAction *m_manual_action;
};

#endif
