/***************************************************************************
    smb4kuser.h  -  This class provides a container for the user 
    information that is read from /etc/passwd.
                             -------------------
    begin                : Mo Mr 1 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KUSER_H
#define SMB4KUSER_H

// Qt includes
#include <qstring.h>


/**
 * This class provides a container to store non-system users in.
 */
 
class Smb4KUser
{
  public:
    /**
     * The constructor
     */
    Smb4KUser( const int uid, const int gid );
    /**
     * The empty constructor.
     */
    Smb4KUser() {}
    /**
     * The destructor
     */
    ~Smb4KUser();
    /**
     * Returns the name of the user.
     */
    QString user() const { return m_user; }
    /**
     * Returns the group of the user.
     */
    QString group() const { return m_group; }
    /**
     * Returns the UID of the user.
     */
    int uid() const { return m_uid; }
    /**
     * Returns the GID of the user.
     */
    int gid() const { return m_gid; }

  private:
    /**
     * The name of the user.
     */
    QString m_user;
    /**
     * The group of the user.
     */
    QString m_group;
    /** 
     * The UID of the user.
     */
    int m_uid;
    /**
     * The GID of the user.
     */
    int m_gid;
};

#endif
