/*=========================================================================

Program:   MIMX Meshing Toolkit
Module:    $RCSfile: vtkMimxApplyNodeElementNumbers.h,v $
Language:  C++
Date:      $Date: 2008/03/21 20:10:49 $
Version:   $Revision: 1.3 $

 Musculoskeletal Imaging, Modelling and Experimentation (MIMX)
 Center for Computer Aided Design
 The University of Iowa
 Iowa City, IA 52242
 http://www.ccad.uiowa.edu/mimx/
 
Copyright (c) The University of Iowa. All rights reserved.
See MIMXCopyright.txt or http://www.ccad.uiowa.edu/mimx/Copyright.htm for details.

This software is distributed WITHOUT ANY WARRANTY; without even 
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

// To associate starting node and element numbers for  output
// The node and element numbers are stored in vtkPointData and vtkCellData
// respectively. The array containing  nodes numbers will be 
// "_Nodes_Numbers" and that of elements is "_Element_Numbers".

#ifndef __vtkMimxApplyNodeElementNumbers_h
#define __vtkMimxApplyNodeElementNumbers_h

#include "vtkMimxCommonWin32Header.h"

class vtkIdList;
class vtkIntArray;
class vtkUnstructuredGrid;

class VTK_MIMXCOMMON_EXPORT vtkMimxApplyNodeElementNumbers
{
public:
        vtkMimxApplyNodeElementNumbers();
        ~vtkMimxApplyNodeElementNumbers();
        void SetUnstructuredGrid(vtkUnstructuredGrid*);
        void SetStartingNodeNumber(int StartNodeNumber);
        void SetStartingElementNumber(int StartElementNumber);
        void SetElementSetName(const char *ElSetName);
        void SetNodeSetName(const char *NSetName);
        void ApplyNodeNumbers();
        void ApplyElementNumbers();
private:
        vtkUnstructuredGrid *UGrid;
        int StartingNodeNumber;
        int StartingElementNumber;
        const char *ElementSetName;
        const char *NodeSetName;
        void MapNewAndOldElementNumbers();
};

#endif
