static variable window = NULL;
static variable statusbar_counter = 1;

static define statusbar_push (button, statusbar)
{
   statusbar_counter++;
   () = gtk_statusbar_push (statusbar,1,
   			sprintf("something %d",statusbar_counter));
}

static define statusbar_pop (button, statusbar)
{
   gtk_statusbar_pop (statusbar, 1);
}

static define statusbar_steal (button, statusbar)
{
   gtk_statusbar_remove (statusbar, 1, 4);
}

static define statusbar_popped (statusbar, context_id, text)
{
   %if (!statusbar->messages)
   %	statusbar_counter = 1;
}

static define statusbar_contexts (statusbar)
{
   variable string = "any context";
   vmessage("GtkStatusBar: context=\"%s\", context_id=%d",
	   string,
	   gtk_statusbar_get_context_id (statusbar, string));
  
   string = "idle messages";
   vmessage("GtkStatusBar: context=\"%s\", context_id=%d",
	   string,
	   gtk_statusbar_get_context_id (statusbar, string));
  
   string = "some text";
   vmessage("GtkStatusBar: context=\"%s\", context_id=%d",
	   string,
	   gtk_statusbar_get_context_id (statusbar, string));

   string = "hit the mouse";
   vmessage("GtkStatusBar: context=\"%s\", context_id=%d",
	   string,
	   gtk_statusbar_get_context_id (statusbar, string));

   string = "hit the mouse2";
   vmessage("GtkStatusBar: context=\"%s\", context_id=%d",
	   string,
	   gtk_statusbar_get_context_id (statusbar, string));
}

#iffalse 
define statusbar_dump_stack (statusbar)
{
   GSList *list;

   for (list = statusbar->messages; list; list = list->next) {
	GtkStatusbarMsg *msg;
	msg = list->data;
	vmessage("context_id: %d, message_id: %d, status_text: \"%s\"",
               msg->context_id,
               msg->message_id,
               msg->text);
   }
}
#endif

public define create_statusbar (test)
{
   if (window == NULL) {

  	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  	() = g_signal_connect (window, "destroy",
			   &gtk_widget_destroyed,
			  &window);

	gtk_window_set_title ( window, "statusbar");
	gtk_container_set_border_width ( window, 0);

	variable box1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add ( window, box1);

	variable box2 = gtk_vbox_new (FALSE, 10);
	gtk_container_set_border_width ( (box2), 10);
	gtk_box_pack_start ( box1, box2, TRUE, TRUE, 0);

	variable statusbar = gtk_statusbar_new ();
	gtk_box_pack_end ( (box1), statusbar, TRUE, TRUE, 0);

	variable button = gtk_button_new_with_label("push something");
	gtk_container_add(box2,button);
	() = g_signal_connect (button,"clicked",&statusbar_push,statusbar);

	button = gtk_button_new_with_label("pop");
	gtk_container_add(box2,button);
	() = g_signal_connect(button,"clicked",
      					&statusbar_pop,statusbar);

	button = gtk_button_new_with_label("steal #4");
	gtk_container_add(box2,button);
	() = g_signal_connect(button,"clicked",
      					&statusbar_steal, statusbar);

	button = gtk_button_new_with_label("test contexts");
	gtk_container_add(box2,button);
	() = g_signal_connect_swapped ( button,"clicked",
      					&statusbar_contexts, statusbar);

	test.lower = generic_close_button(box1,window);
    }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
