/*
	skyeye_config.h - config file interface for skyeye.
	Copyright (C) 2003 Skyeye Develop Group
	for help please send mail to <skyeye-developer@lists.sf.linuxforum.net> 
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/
/* 4/02/2003	add net option
 * 				walimis <walimi@peoplemail.com.cn>
 * 3/21/2003 	Add config file interface to skyeye. 
 * 		Rename memmap.conf to skyeye.conf
 * 		Move some code from armmem.c.
 *		walimis <walimi@peoplemail.com.cn> 		
 * 10/24/2005	add dbct test speed function
 *				teawater <c7code-uc@yahoo.com.cn>
 * */
#ifndef __SKYEYE_CONFIG_H_
#define __SKYEYE_CONFIG_H_

//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "arch/arm/common/armdefs.h"
#else
#include "armdefs.h"
#endif
// end ----------------------------------------------------------------------

#include "skyeye_types.h"
#include "skyeye_options.h"

#define DEFAULT_CONFIG_FILE "skyeye.conf"
#define MAX_FILE_NAME 256

#define SKYEYE_OUTREGS(fd) { fprintf ((fd), "R %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,C %x,S %x,%x,%x,%x,%x,%x,%x,M %x,B %x,E %x,I %x,P %x,T %x,L %x,D %x,",\
                         state->Reg[0],state->Reg[1],state->Reg[2],state->Reg[3], \
                         state->Reg[4],state->Reg[5],state->Reg[6],state->Reg[7], \
                         state->Reg[8],state->Reg[9],state->Reg[10],state->Reg[11], \
                         state->Reg[12],state->Reg[13],state->Reg[14],state->Reg[15], \
			 state->Cpsr,   state->Spsr[0], state->Spsr[1], state->Spsr[2],\
                         state->Spsr[3],state->Spsr[4], state->Spsr[5], state->Spsr[6],\
			 state->Mode,state->Bank,state->ErrorCode,state->instr,state->pc,\
			 state->temp,state->loaded,state->decoded);}

#define SKYEYE_OUTMOREREGS(fd) { fprintf ((fd),"\
RUs %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,\
RF  %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,\
RI  %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,\
RS  %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,\
RA  %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,\
RUn %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x\n",\
                         state->RegBank[0][0],state->RegBank[0][1],state->RegBank[0][2],state->RegBank[0][3], \
                         state->RegBank[0][4],state->RegBank[0][5],state->RegBank[0][6],state->RegBank[0][7], \
                         state->RegBank[0][8],state->RegBank[0][9],state->RegBank[0][10],state->RegBank[0][11], \
                         state->RegBank[0][12],state->RegBank[0][13],state->RegBank[0][14],state->RegBank[0][15], \
                         state->RegBank[1][0],state->RegBank[1][1],state->RegBank[1][2],state->RegBank[1][3], \
                         state->RegBank[1][4],state->RegBank[1][5],state->RegBank[1][6],state->RegBank[1][7], \
                         state->RegBank[1][8],state->RegBank[1][9],state->RegBank[1][10],state->RegBank[1][11], \
                         state->RegBank[1][12],state->RegBank[1][13],state->RegBank[1][14],state->RegBank[1][15], \
                         state->RegBank[2][0],state->RegBank[2][1],state->RegBank[2][2],state->RegBank[2][3], \
                         state->RegBank[2][4],state->RegBank[2][5],state->RegBank[2][6],state->RegBank[2][7], \
                         state->RegBank[2][8],state->RegBank[2][9],state->RegBank[2][10],state->RegBank[2][11], \
                         state->RegBank[2][12],state->RegBank[2][13],state->RegBank[2][14],state->RegBank[2][15], \
                         state->RegBank[3][0],state->RegBank[3][1],state->RegBank[3][2],state->RegBank[3][3], \
                         state->RegBank[3][4],state->RegBank[3][5],state->RegBank[3][6],state->RegBank[3][7], \
                         state->RegBank[3][8],state->RegBank[3][9],state->RegBank[3][10],state->RegBank[3][11], \
                         state->RegBank[3][12],state->RegBank[3][13],state->RegBank[3][14],state->RegBank[3][15], \
                         state->RegBank[4][0],state->RegBank[4][1],state->RegBank[4][2],state->RegBank[4][3], \
                         state->RegBank[4][4],state->RegBank[4][5],state->RegBank[4][6],state->RegBank[4][7], \
                         state->RegBank[4][8],state->RegBank[4][9],state->RegBank[4][10],state->RegBank[4][11], \
                         state->RegBank[4][12],state->RegBank[4][13],state->RegBank[4][14],state->RegBank[4][15], \
                         state->RegBank[5][0],state->RegBank[5][1],state->RegBank[5][2],state->RegBank[5][3], \
                         state->RegBank[5][4],state->RegBank[5][5],state->RegBank[5][6],state->RegBank[5][7], \
                         state->RegBank[5][8],state->RegBank[5][9],state->RegBank[5][10],state->RegBank[5][11], \
                         state->RegBank[5][12],state->RegBank[5][13],state->RegBank[5][14],state->RegBank[5][15] \
		);}


#define SA1110        0x6901b110
#define SA1100        0x4401a100
#define PXA250	      0x69052100
#define PXA270 	      0x69054110
//#define PXA250              0x69052903
// 0x69052903;  //PXA250 B1 from intel 278522-001.pdf

typedef struct machine_config
{
	const char *machine_name;	/*e.g.at91,ep7312,clps711x */
	void (*mach_init) (ARMul_State * state, struct machine_config * this_mach);	/*should be called 
											   when the machine reset */
	void (*mach_io_do_cycle) (ARMul_State * state);
	void (*mach_io_reset) (ARMul_State * state);	/*io reset when init io */
	void (*mach_update_int) (ARMul_State * state);	/*update interrupt pend bit */
	  ARMword (*mach_io_read_byte) (ARMul_State * state, ARMword addr);
	void (*mach_io_write_byte) (ARMul_State * state, ARMword addr,
				    ARMword data);
	  ARMword (*mach_io_read_halfword) (ARMul_State * state,
					    ARMword addr);
	void (*mach_io_write_halfword) (ARMul_State * state, ARMword addr,
					ARMword data);
	  ARMword (*mach_io_read_word) (ARMul_State * state, ARMword addr);
	void (*mach_io_write_word) (ARMul_State * state, ARMword addr,
				    ARMword data);

	/*ywc 2005-03-30 */
	  ARMword (*mach_flash_read_byte) (ARMul_State * state, ARMword addr);
	void (*mach_flash_write_byte) (ARMul_State * state, ARMword addr,
				       ARMword data);
	  ARMword (*mach_flash_read_halfword) (ARMul_State * state,
					       ARMword addr);
	void (*mach_flash_write_halfword) (ARMul_State * state, ARMword addr,
					   ARMword data);
	  ARMword (*mach_flash_read_word) (ARMul_State * state, ARMword addr);
	void (*mach_flash_write_word) (ARMul_State * state, ARMword addr,
				       ARMword data);

	/* for I/O device
	 * */
	void (*mach_set_intr) (u32 interrupt);	/*set interrupt pending bit */
	int (*mach_pending_intr) (u32 interrupt);	/*test if interrupt is pending. 1: pending */
	void (*mach_update_intr) (void *mach);	/*update interrupt pending bit */

	int (*mach_mem_read_byte) (void *mach, u32 addr, u32 * data);
	int (*mach_mem_write_byte) (void *mach, u32 addr, u32 data);
	/* FIXME! point to the current ARMul_State.
	 * */
	void *state;
	/* FIXME!
	 * we just temporarily put devices here
	 * */
	struct device_desc **devices;
	int dev_count;

} machine_config_t;

#define MAX_BANK 8
#define MAX_STR  1024

#define MEMTYPE_IO		0
#define MEMTYPE_RAM		1
#define MEMTYPE_ROM		2

/*ywc 2005-03-30*/
#define MEMTYPE_FLASH           3

/*ksh 2004-11-26,energy profile flag*/
typedef struct
{
	char logfile[MAX_FILE_NAME];
	char filename[MAX_FILE_NAME];
	ARMword energy_prof;
} energy_config_t;

/*net option*/
typedef struct
{
	int state;		// "on"=1,"off"=0, "on" means nic exist, "off" means nic don't exist
	unsigned char macaddr[6];
	unsigned char hostip[4];	//the hostos ip addr, used in tuntap net device 
	int ethmod;
	int fd;			// the opend dev file handle
	int hubindex;		//the index means the hub number, such as vnet0, vnet1...
	//nic functions
	int (*net_init) (int index, unsigned char *macaddr, unsigned char *hostip);	//the index means nic index 
	unsigned char (*net_output) (int if_fd, ARMul_State * state,
				     unsigned char startpage,
				     unsigned short packet_len);
	void (*net_input) (int if_fd, ARMul_State * state);
} net_config_t;

#define NET_MAXNICNUM_PER_HOST  4

/*uart option*/
/*add by walimis. 20030808*/
typedef struct
{
	int fd_in;		/*file description of input */
	int fd_out;		/*file description of output */
} uart_config_t;
//chy 2003-08-20, used to log the instr&regs states to log file
typedef struct
{
	FILE *log_fd;
	int logon;		//log or not
	unsigned long long start;	//start clock
	unsigned long long end;	//end clock
	unsigned long long length;	//the max instr length of log file
} log_config_t;
/* some devices may have the same parameters.
 * type: device's type name
 * name: device's instance name
 * base: I/O or memory base address 
 * size: size of I/O or memory.
 * interrupts: 
 * */
typedef struct common_config
{
	char *type;
	char *name;
	u32 base;
	u32 size;
	u32 interrupts[MAX_INTERRUPT];

} common_config_t;

/*config file option struct*/
int do_dummy_option ();
int do_arch_option ();
int do_cpu_option ();
int do_mach_option ();
int do_mem_bank_option ();
int do_net_option ();
int do_energy_option ();
int do_uart_option ();
int do_lcd_option ();
int do_flash_option ();

/*ywc 2005-04-01*/
int do_dbct_option ();

int do_log_option ();
int do_step_disassemble_option ();
//teawater add DBCT_TEST_SPEED 2005.10.04---------------------------------------
#ifdef DBCT_TEST_SPEED
int do_dbct_test_speed_sec();
#endif	//DBCT_TEST_SPEED
//AJ2D--------------------------------------------------------------------------

#define MAX_OPTION_NAME 32
#define MAX_PARAM_NAME  32

typedef struct skyeye_option_t
{
	char *name;
	int (*do_option) (struct skyeye_option_t * this_opion,
			  int num_params, const char *params[]);
	int do_num;		/*number of call do_option function */
	int max_do_num;		/*max number of call do_option function. 
				   where should we reset these values? */
} skyeye_option_t;

typedef struct
{
	char *arch_name;
	void (*init) ();
	void (*reset) ();
	void (*step_once) ();
	void (*set_pc) (WORD addr);
	WORD (*get_pc)();
	//chy 2006-04-15
	int (*ICE_write_byte) (WORD addr, uint8_t data);
	int (*ICE_read_byte)(WORD addr, uint8_t *pv);	
	int (*parse_cpu) (const char *param[]);
	int (*parse_mach) (machine_config_t * mach, const char *param[]);
	int (*parse_mem) (int num_params, const char *params[]);
} arch_config_t;
typedef struct
{
	arch_config_t *arch;
	//cpu_config_t *cpu;
	machine_config_t *mach;
	//mem_config_t mem;
//chy 2003-09-12, now support more io banks
//      ioaddr_config_t ioaddr; //used for ARMul_notIOaddr funciton
	net_config_t net[NET_MAXNICNUM_PER_HOST];
	uart_config_t uart;
	log_config_t log;
	ARMword start_address;

	/*ywc 2005-03-31, no_dbct used by Dynamic Binary Code Translation */
	ARMword no_dbct;

	/*ksh 2004-11-26,energy profile flag */
	energy_config_t energy;

	char config_file[MAX_FILE_NAME];

	//oyangjian add here 2004-11-3
	ARMword can_step_disassemble;
	//teawater add for new tb manage function 2005.07.10----------------------------
	uint32_t tb_tbt_size;
	uint32_t tb_tbp_size;
//teawater add DBCT_TEST_SPEED 2005.10.04---------------------------------------
#ifdef DBCT_TEST_SPEED
	int	dbct_test_speed_sec;
#endif	//DBCT_TEST_SPEED
//AJ2D--------------------------------------------------------------------------
} skyeye_config_t;

skyeye_config_t skyeye_config;

static skyeye_option_t skyeye_options[] = {
	{"arch", do_arch_option, 0, 1},
	{"cpu", do_cpu_option, 0, 1},
	{"mach", do_mach_option, 0, 1},

	/*mem option */
	{"mem_bank", do_mem_bank_option, 0, MAX_BANK},

	{"net", do_net_option, 0, 10},
	{"energy", do_energy_option, 0, 1},
	{"uart", do_uart_option, 0, 1},
	{"lcd", do_lcd_option, 0, 1},
	{"flash", do_flash_option, 0, 1},

	/*ywc 2005-04-01 */
	//teawater add for new tb manage function 2005.07.10----------------------------
	{"dbct", do_dbct_option, 0, 3},

	/*log option */
	{"log", do_log_option, 0, 1},

	/*
	 * this option can disassmebl the next c statement 
	 * with assemble code and may be have some usefull
	 * 
	 */
//teawater add DBCT_TEST_SPEED 2005.10.04---------------------------------------
  {"step_disassemble", do_step_disassemble_option, 0, 1},
#ifdef DBCT_TEST_SPEED
	{"dbct_test_speed_sec", do_dbct_test_speed_sec, 0, 1},
#endif	//DBCT_TEST_SPEED
//AJ2D--------------------------------------------------------------------------
};



int skyeye_read_config ();
#endif	/*__SKYEYE_CONFIG_H_*/
