/* # skkinput (Simple Kana-Kanji Input)
 * defaultKeyMap.h --- Define Default Keymap
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef defaultKeyMap_h
#define defaultKeyMap_h
#ifdef THIS_IS_NECESSARY
/*
 * SKK ⡼ɡפȡѥ⡼ɡפΥХɡ
 */
static struct skkinputKeyBind defaultSkkMapBind[] = {
  { 1, "\0",	FUNCNO_J_SET_MARK_COMMAND,	/* C-@ */ },
  { 1, "\01",	FUNCNO_J_BEGINNING_OF_LINE,	/* C-a */ },
  { 1, "\02",	FUNCNO_J_BACKWARD_CHAR,		/* C-b */ },
  { 1, "\03",	FUNCNO_J_PREFIX_CHAR,		/* C-c */ },
  { 1, "\04",	FUNCNO_J_DELETE_CHAR,		/* C-d */ },
  { 1, "\05",	FUNCNO_J_END_OF_LINE,		/* C-e */ },
  { 1, "\06",	FUNCNO_J_FORWARD_CHAR,		/* C-f */ },
  { 1, "\07",	FUNCNO_J_KEYBOARD_QUIT,		/* C-g */ },
  { 1, "\010",	FUNCNO_J_DELETE_BACKWARD_CHAR,	/* C-h */ },
  { 1, "\011",	FUNCNO_J_TRY_COMPLETION,	/* C-i */ },
  { 1, "\012",	FUNCNO_J_KANAINPUT_MODE_ON,	/* C-j */ },
  { 1, "\013",	FUNCNO_J_KILL_LINE,		/* C-k */ },
  { 1, "\014",	FUNCNO_J_REDRAW,		/* C-l */ },
  { 1, "\015",	FUNCNO_J_NEWLINE,		/* C-m */ },
  { 1, "\016",	FUNCNO_J_NEXT_LINE,		/* C-n */ },
  { 1, "\017",	FUNCNO_INVALID_CHAR,		/* C-o */ },
  { 1, "\020",	FUNCNO_J_PREVIOUS_LINE,		/* C-p */ },
  { 1, "\021",	FUNCNO_J_SENDBACK_NEXT_KEY,	/* C-q */ },
  { 1, "\022",	FUNCNO_INVALID_CHAR,		/* C-r */ },
  { 1, "\023",	FUNCNO_INVALID_CHAR,		/* C-s */ },
  { 1, "\024",	FUNCNO_J_TRANSPOSE_CHARS,	/* C-t */ },
  { 1, "\025",	FUNCNO_INVALID_CHAR,		/* C-u */ },
  { 1, "\026",	FUNCNO_INVALID_CHAR,		/* C-v */ },
  { 1, "\027",	FUNCNO_J_KILL_REGION,		/* C-w */ },
  { 1, "\030",	FUNCNO_J_PREFIX_CHAR,		/* C-x */ },
  { 1, "\031",	FUNCNO_J_YANK,			/* C-y */ },
  { 1, "\032",	FUNCNO_INVALID_CHAR,		/* C-z */ },
  { 1, "\033",	FUNCNO_J_PREFIX_CHAR,		/* C-\[ */ },
  { 1, "\034",	FUNCNO_INVALID_CHAR,		/* C-\\ */ },
  { 1, "\035",	FUNCNO_INVALID_CHAR,		/* C-\] */ },
  { 1, "\036",	FUNCNO_INVALID_CHAR,		/* C-^ */ },
  { 1, "\037",	FUNCNO_INVALID_CHAR,		/* C-_ */ },
  { 1, "\177",	FUNCNO_J_DELETE_CHAR,		/* 0x7f */ },

  { 2, "\030\003", FUNCNO_CLOSE_SKKINPUT,	/* C-xC-c */ },
  { 2, "\030\023", FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO,	/* C-xC-s */ },
  { 2, "\030\030", FUNCNO_J_EXCHANGE_POINT_AND_MARK,	/* C-xC-x */ },
  { 2, "\030\021", FUNCNO_VC_TOGGLE_CHATMODE,	/* C-xC-q */ },
  { 2, "\030\005", FUNCNO_VC_TOGGLE_EGGNL,	/* C-xC-e */ },
  { 2, "\033w",    FUNCNO_J_KILL_RING_SAVE,	/* M-w */ },
  { 2, "\033 ",    FUNCNO_J_SET_MARK_COMMAND,	/* M-  */ },
  { 2, "\033~",    FUNCNO_NOT_MODIFIED,		/* M-~ */ },
  { 2, "\033f",    FUNCNO_J_FORWARD_WORD,	/* M-f */ },
  { 2, "\033b",    FUNCNO_J_BACKWARD_WORD,	/* M-b */ },
  { 2, "\033c",    FUNCNO_J_CAPITALIZE_WORD,	/* M-c */ },
  { 2, "\033u",    FUNCNO_J_UPCASE_WORD,	/* M-u */ },
  { 2, "\033l",    FUNCNO_J_DOWNCASE_WORD,	/* M-l */ },

  { 1, { CHARA_LEFT },	FUNCNO_J_BACKWARD_CHAR, },
  { 1, { CHARA_RIGHT },	FUNCNO_J_FORWARD_CHAR, },
  { 1, { CHARA_UP },	FUNCNO_J_PREVIOUS_LINE, },
  { 1, { CHARA_DOWN },	FUNCNO_J_NEXT_LINE, },
  { 1, { CHARA_END },	FUNCNO_J_END_OF_LINE, },
  { 1, { CHARA_BEGIN },	FUNCNO_J_BEGINNING_OF_LINE, },
  { 1, { CHARA_INSERT },FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT, },
  { 1, { CHARA_HOME },  FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO },

  { 0, "",	FUNCNO_NOFUNCTION },
} ;
#endif

/*
 * ֤ʥ⡼ɡפȡ֥ʥ⡼ɡפΥХɡ
 */
static struct skkinputKeyBind defaultSkkJMapBind[] = {
  { 1, "\0",	FUNCNO_J_SET_MARK_COMMAND,	/* C-@ */ },
  { 1, "\01",	FUNCNO_J_BEGINNING_OF_LINE,	/* C-a */ },
  { 1, "\02",	FUNCNO_J_BACKWARD_CHAR,		/* C-b */ },
  { 1, "\03",	FUNCNO_J_PREFIX_CHAR,		/* C-c */ },
  { 1, "\04",	FUNCNO_J_DELETE_CHAR,		/* C-d */ },
  { 1, "\05",	FUNCNO_J_END_OF_LINE,		/* C-e */ },
  { 1, "\06",	FUNCNO_J_FORWARD_CHAR,		/* C-f */ },
  { 1, "\07",	FUNCNO_J_KEYBOARD_QUIT,		/* C-g */ },
  { 1, "\010",	FUNCNO_J_DELETE_BACKWARD_CHAR,	/* C-h */ },
  { 1, "\011",	FUNCNO_J_TRY_COMPLETION,	/* C-i */ },
  { 1, "\012",	FUNCNO_J_KANAINPUT_MODE_ON,	/* C-j */ },
  { 1, "\013",	FUNCNO_J_KILL_LINE,		/* C-k */ },
  { 1, "\014",	FUNCNO_J_REDRAW,		/* C-l */ },
  { 1, "\015",	FUNCNO_J_NEWLINE,		/* C-m */ },
  { 1, "\016",	FUNCNO_J_NEXT_LINE,		/* C-n */ },
  { 1, "\017",	FUNCNO_INVALID_CHAR,		/* C-o */ },
  { 1, "\020",	FUNCNO_J_PREVIOUS_LINE,		/* C-p */ },
  { 1, "\021",	FUNCNO_J_SENDBACK_NEXT_KEY,	/* C-q */ },
  { 1, "\022",	FUNCNO_INVALID_CHAR,		/* C-r */ },
  { 1, "\023",	FUNCNO_INVALID_CHAR,		/* C-s */ },
  { 1, "\024",	FUNCNO_J_TRANSPOSE_CHARS,	/* C-t */ },
  { 1, "\025",	FUNCNO_INVALID_CHAR,		/* C-u */ },
  { 1, "\026",	FUNCNO_INVALID_CHAR,		/* C-v */ },
  { 1, "\027",	FUNCNO_J_KILL_REGION,		/* C-w */ },
  { 1, "\030",	FUNCNO_J_PREFIX_CHAR,		/* C-x */ },
  { 1, "\031",	FUNCNO_J_YANK,			/* C-y */ },
  { 1, "\032",	FUNCNO_INVALID_CHAR,		/* C-z */ },
  { 1, "\033",	FUNCNO_J_PREFIX_CHAR,		/* C-\[ */ },
  { 1, "\034",	FUNCNO_INVALID_CHAR,		/* C-\\ */ },
  { 1, "\035",	FUNCNO_INVALID_CHAR,		/* C-\] */ },
  { 1, "\036",	FUNCNO_INVALID_CHAR,		/* C-^ */ },
  { 1, "\037",	FUNCNO_INVALID_CHAR,		/* C-_ */ },
  { 1, "\040",	FUNCNO_J_START_HENKAN,		/*   */ },
  { 1, "\044",	FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT, /* $ */ },
  { 1, "\054",	FUNCNO_J_INSERT_COMMA,		/* , */ },
  { 1, "\056",	FUNCNO_J_INSERT_PERIOD,		/* . */ },
  { 1, "\057",	FUNCNO_J_ABBREV_INPUT,		/* / */ },
  { 1, "\074",	FUNCNO_J_SET_HENKAN_POINT,	/* < */ },
  { 1, "\076",	FUNCNO_J_SET_HENKAN_POINT,	/* > */ },
  { 1, "\077",	FUNCNO_J_SET_HENKAN_POINT,	/* ? */ },
  { 1, "\100",	FUNCNO_J_TODAY,			/* @ */ },
  { 1, "\101",	FUNCNO_J_SET_HENKAN_POINT, 	/* A */ },
  { 1, "\102",	FUNCNO_J_SET_HENKAN_POINT, 	/* B */ },
  { 1, "\103",	FUNCNO_J_SET_HENKAN_POINT, 	/* C */ },
  { 1, "\104",	FUNCNO_J_SET_HENKAN_POINT, 	/* D */ },
  { 1, "\105",	FUNCNO_J_SET_HENKAN_POINT, 	/* E */ },
  { 1, "\106",	FUNCNO_J_SET_HENKAN_POINT, 	/* F */ },
  { 1, "\107",	FUNCNO_J_SET_HENKAN_POINT, 	/* G */ },
  { 1, "\110",	FUNCNO_J_SET_HENKAN_POINT, 	/* H */ },
  { 1, "\111",	FUNCNO_J_SET_HENKAN_POINT, 	/* I */ },
  { 1, "\112",	FUNCNO_J_SET_HENKAN_POINT, 	/* J */ },
  { 1, "\113",	FUNCNO_J_SET_HENKAN_POINT, 	/* K */ },
  { 1, "\114",	FUNCNO_J_ZENKAKU_EIJI, 		/* L */ },
  { 1, "\115",	FUNCNO_J_SET_HENKAN_POINT, 	/* M */ },
  { 1, "\116",	FUNCNO_J_SET_HENKAN_POINT, 	/* N */ },
  { 1, "\117",	FUNCNO_J_SET_HENKAN_POINT, 	/* O */ },
  { 1, "\120",	FUNCNO_J_SET_HENKAN_POINT, 	/* P */ },
  { 1, "\121",	FUNCNO_J_SET_HENKAN_POINT_SUBR, /* Q */ },
  { 1, "\122",	FUNCNO_J_SET_HENKAN_POINT, 	/* R */ },
  { 1, "\123",	FUNCNO_J_SET_HENKAN_POINT, 	/* S */ },
  { 1, "\124",	FUNCNO_J_SET_HENKAN_POINT, 	/* T */ },
  { 1, "\125",	FUNCNO_J_SET_HENKAN_POINT, 	/* U */ },
  { 1, "\126",	FUNCNO_J_SET_HENKAN_POINT, 	/* V */ },
  { 1, "\127",	FUNCNO_J_SET_HENKAN_POINT, 	/* W */ },
  { 1, "\130",	FUNCNO_J_PURGE_FROM_JISYO, 	/* X */ },
  { 1, "\131",	FUNCNO_J_SET_HENKAN_POINT, 	/* Y */ },
  { 1, "\132",	FUNCNO_J_SET_HENKAN_POINT, 	/* Z */ },
  { 1, "\134",	FUNCNO_J_INPUT_BY_CODE_OR_MENU,/* \\ */ },
  { 1, "\141",	FUNCNO_J_INSERT_A,		/* a */ },
  { 1, "\142",	FUNCNO_J_KANA_INPUT,		/* b */ },
  { 1, "\143",	FUNCNO_J_KANA_INPUT,		/* c */ },
  { 1, "\144",	FUNCNO_J_KANA_INPUT,		/* d */ },
  { 1, "\145",	FUNCNO_J_INSERT_E,		/* e */ },
  { 1, "\146",	FUNCNO_J_KANA_INPUT,		/* f */ },
  { 1, "\147",	FUNCNO_J_KANA_INPUT,		/* g */ },
  { 1, "\150",	FUNCNO_J_KANA_INPUT,		/* h */ },
  { 1, "\151",	FUNCNO_J_INSERT_I,		/* i */ },
  { 1, "\152",	FUNCNO_J_KANA_INPUT,		/* j */ },
  { 1, "\153",	FUNCNO_J_KANA_INPUT,		/* k */ },
  { 1, "\154",	FUNCNO_J_MODE_OFF,		/* l */ },
  { 1, "\155",	FUNCNO_J_KANA_INPUT,		/* m */ },
  { 1, "\156",	FUNCNO_J_KANA_INPUT,		/* n */ },
  { 1, "\157",	FUNCNO_J_KANA_INPUT,		/* o ( not j_insert_o ) */ },
  { 1, "\160",	FUNCNO_J_KANA_INPUT,		/* p */ },
  { 1, "\161",	FUNCNO_J_TOGGLE_KANA,		/* q */ },
  { 1, "\162",	FUNCNO_J_KANA_INPUT,		/* r */ },
  { 1, "\163",	FUNCNO_J_KANA_INPUT,		/* s */ },
  { 1, "\164",	FUNCNO_J_KANA_INPUT,		/* t */ },
  { 1, "\165",	FUNCNO_J_INSERT_U,		/* u */ },
  { 1, "\166",	FUNCNO_J_KANA_INPUT,		/* v */ },
  { 1, "\167",	FUNCNO_J_KANA_INPUT,		/* w */ },
  { 1, "\170",	FUNCNO_J_PREVIOUS_CANDIDATE,	/* x */ },
  { 1, "\171",	FUNCNO_J_KANA_INPUT,		/* y */ },
  { 1, "\172",	FUNCNO_J_KANA_INPUT,		/* z */ },
  { 1, "\177",	FUNCNO_J_DELETE_CHAR,		/* 0x7f */ },

  { 2, "\030\003", FUNCNO_CLOSE_SKKINPUT,	/* C-xC-c */ },
  { 2, "\030\023", FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO,	/* C-xC-s */ },
  { 2, "\030\030", FUNCNO_J_EXCHANGE_POINT_AND_MARK,	/* C-xC-x */ },
  { 2, "\030\021", FUNCNO_VC_TOGGLE_CHATMODE,	/* C-xC-q */ },
  { 2, "\030\005", FUNCNO_VC_TOGGLE_EGGNL,	/* C-xC-e */ },
  { 2, "\033w",    FUNCNO_J_KILL_RING_SAVE,	/* M-w */ },
  { 2, "\033 ",    FUNCNO_J_SET_MARK_COMMAND,	/* M-  */ },
  { 2, "\033~",    FUNCNO_NOT_MODIFIED,		/* M-~ */ },
  { 2, "\033f",    FUNCNO_J_FORWARD_WORD,	/* M-f */ },
  { 2, "\033b",    FUNCNO_J_BACKWARD_WORD,	/* M-b */ },
  { 2, "\033c",    FUNCNO_J_CAPITALIZE_WORD,	/* M-c */ },
  { 2, "\033u",    FUNCNO_J_UPCASE_WORD,	/* M-u */ },
  { 2, "\033l",    FUNCNO_J_DOWNCASE_WORD,	/* M-l */ },

  { 1, { CHARA_LEFT },	FUNCNO_J_BACKWARD_CHAR, },
  { 1, { CHARA_RIGHT },	FUNCNO_J_FORWARD_CHAR, },
  { 1, { CHARA_UP },	FUNCNO_J_PREVIOUS_LINE, },
  { 1, { CHARA_DOWN },	FUNCNO_J_NEXT_LINE, },
  { 1, { CHARA_END },	FUNCNO_J_END_OF_LINE, },
  { 1, { CHARA_BEGIN },	FUNCNO_J_BEGINNING_OF_LINE, },
  { 1, { CHARA_INSERT },FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT, },
  { 1, { CHARA_HOME },  FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO },

  { 0, "",	FUNCNO_NOFUNCTION },
} ;

/*
 * ABBREV⡼ɡפΥХɡ
 */
static struct skkinputKeyBind defaultAbbrevMapBind[] = {
  { 1, "\0",	FUNCNO_INVALID_CHAR,		/* C-@ */ },
  { 1, "\01",	FUNCNO_J_BEGINNING_OF_LINE,	/* C-a */ },
  { 1, "\02",	FUNCNO_J_BACKWARD_CHAR,		/* C-b */ },
  { 1, "\03",	FUNCNO_J_PREFIX_CHAR,		/* C-c */ },
  { 1, "\04",	FUNCNO_J_DELETE_CHAR,		/* C-d */ },
  { 1, "\05",	FUNCNO_J_END_OF_LINE,		/* C-e */ },
  { 1, "\06",	FUNCNO_J_FORWARD_CHAR,		/* C-f */ },
  { 1, "\07",	FUNCNO_J_KEYBOARD_QUIT,		/* C-g */ },
  { 1, "\010",	FUNCNO_J_DELETE_BACKWARD_CHAR,	/* C-h */ },
  { 1, "\011",	FUNCNO_J_TRY_COMPLETION,	/* C-i */ },
  { 1, "\012",	FUNCNO_J_KANAINPUT_MODE_ON,	/* C-j */ },
  { 1, "\013",	FUNCNO_J_KILL_LINE,		/* C-k */ },
  { 1, "\014",	FUNCNO_J_REDRAW,		/* C-l */ },
  { 1, "\015",	FUNCNO_J_NEWLINE,		/* C-m */ },
  { 1, "\016",	FUNCNO_J_NEXT_LINE,		/* C-n */ },
  { 1, "\017",	FUNCNO_INVALID_CHAR,		/* C-o */ },
  { 1, "\020",	FUNCNO_J_PREVIOUS_LINE,		/* C-p */ },
  { 1, "\021",	FUNCNO_J_ZENKAKU_HENKAN,	/* C-q */ },
  { 1, "\022",	FUNCNO_INVALID_CHAR,		/* C-r */ },
  { 1, "\023",	FUNCNO_INVALID_CHAR,		/* C-s */ },
  { 1, "\024",	FUNCNO_J_TRANSPOSE_CHARS,	/* C-t */ },
  { 1, "\025",	FUNCNO_INVALID_CHAR,		/* C-u */ },
  { 1, "\026",	FUNCNO_INVALID_CHAR,		/* C-v */ },
  { 1, "\027",	FUNCNO_J_KILL_REGION,		/* C-w */ },
  { 1, "\030",	FUNCNO_J_PREFIX_CHAR,		/* C-x */ },
  { 1, "\031",	FUNCNO_J_YANK,			/* C-y */ },
  { 1, "\032",	FUNCNO_INVALID_CHAR,		/* C-z */ },
  { 1, "\033",	FUNCNO_J_PREFIX_CHAR,		/* C-\[ */ },
  { 1, "\034",	FUNCNO_INVALID_CHAR,		/* C-\\ */ },
  { 1, "\035",	FUNCNO_INVALID_CHAR,		/* C-\] */ },
  { 1, "\036",	FUNCNO_INVALID_CHAR,		/* C-^ */ },
  { 1, "\037",	FUNCNO_INVALID_CHAR,		/* C-_ */ },
  { 1, "\040",	FUNCNO_J_START_HENKAN,		/*   */ },
  { 1, "\054",	FUNCNO_J_ABBREV_COMMA,		/* , */ },
  { 1, "\056",	FUNCNO_J_ABBREV_PERIOD,		/* . */ },
  { 1, "\177",	FUNCNO_J_DELETE_CHAR,		/* 0x7f */ },

  { 2, "\030\003", FUNCNO_CLOSE_SKKINPUT,	/* C-xC-c */ },
  { 2, "\030\023", FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO,	/* C-xC-s */ },
  { 2, "\030\030", FUNCNO_J_EXCHANGE_POINT_AND_MARK,	/* C-xC-x */ },
  { 2, "\030\021", FUNCNO_VC_TOGGLE_CHATMODE,	/* C-xC-q */ },
  { 2, "\030\005", FUNCNO_VC_TOGGLE_EGGNL,	/* C-xC-e */ },
  { 2, "\033w",    FUNCNO_J_KILL_RING_SAVE,	/* M-w */ },
  { 2, "\033 ",    FUNCNO_J_SET_MARK_COMMAND,	/* M-  */ },
  { 2, "\033~",    FUNCNO_NOT_MODIFIED,		/* M-~ */ },
  { 2, "\033f",    FUNCNO_J_FORWARD_WORD,	/* M-f */ },
  { 2, "\033b",    FUNCNO_J_BACKWARD_WORD,	/* M-b */ },
  { 2, "\033c",    FUNCNO_J_CAPITALIZE_WORD,	/* M-c */ },
  { 2, "\033u",    FUNCNO_J_UPCASE_WORD,	/* M-u */ },
  { 2, "\033l",    FUNCNO_J_DOWNCASE_WORD,	/* M-l */ },

  { 1, { CHARA_LEFT },	FUNCNO_J_BACKWARD_CHAR, },
  { 1, { CHARA_RIGHT },	FUNCNO_J_FORWARD_CHAR, },
  { 1, { CHARA_UP },	FUNCNO_J_PREVIOUS_LINE, },
  { 1, { CHARA_DOWN },	FUNCNO_J_NEXT_LINE, },
  { 1, { CHARA_END },	FUNCNO_J_END_OF_LINE, },
  { 1, { CHARA_BEGIN },	FUNCNO_J_BEGINNING_OF_LINE, },
  { 1, { CHARA_INSERT },FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT, },
  { 1, { CHARA_HOME },  FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO },

  { 0, "",	FUNCNO_NOFUNCTION },
} ;

#endif
