#include "sjog_sonypi.h"

/*
 * Open the device or exit if failed.
 */
void
sjog_sonypi_init()
{
   gboolean success = FALSE;

   /* 
      TT - First, we check to see if the sonypiDevice variable is not NULL.
      If it's set, then we try to open that device. Otherwise, we try the
      standard /dev/sonypi device, and finally the devfs /dev/misc/sonypi
      device.
    */

   if (sonypiDevice != NULL)
   {
      if ((sonypi_fd = open(sonypiDevice, O_RDONLY)) == -1)
      {
         fprintf(stderr, "Failed to open %s: %s\n", sonypiDevice,
                 strerror(errno));
         fprintf(stderr, "Giving up...\n");
         exit(1);
      }
      else
         success = TRUE;
   }

   if ((success != TRUE)
       && ((sonypi_fd = open("/dev/sonypi", O_RDONLY)) == -1))
   {
      fprintf(stderr, "Failed to open /dev/sonypi: %s\n", strerror(errno));
      fprintf(stderr, "Trying /dev/misc/sonypi... ");
      if ((sonypi_fd = open("/dev/misc/sonypi", O_RDONLY)) == -1)
      {
         fprintf(stderr, "\nFailed to open /dev/misc/sonypi: %s\n",
                 strerror(errno));
         fprintf(stderr, "Giving up...\n");
         exit(1);
      }
      else
      {
         success = TRUE;
         fprintf(stderr, "success\n");
      }
   }
   else
      success = TRUE;

   gdk_input_add(sonypi_fd, GDK_INPUT_READ, sjog_sonypi_read, NULL);
}

/*
 * Reads the jog position by doing a select() on the device.
 */
void
sjog_sonypi_read(gpointer * data)
{
   unsigned char event;

   if (read(sonypi_fd, &event, sizeof(event)) != sizeof(event))
   {
      fprintf(stderr, "read failed: %s\n", strerror(errno));
   }
   switch (event)
   {
        /* the cases sjog actually handle are */
     case SONYPI_EVENT_JOGDIAL_DOWN:
        /* TT - Added the reverse spin capability */
        if (reverseSpinDirection)
           sjog_jog_position_changed(JOG_TOP);
        else
           sjog_jog_position_changed(JOG_BOTTOM);
        break;
     case SONYPI_EVENT_JOGDIAL_UP:
        /* TT - Added the reverse spin capability */
        if (reverseSpinDirection)
           sjog_jog_position_changed(JOG_BOTTOM);
        else
           sjog_jog_position_changed(JOG_TOP);
        break;
     case SONYPI_EVENT_JOGDIAL_DOWN_PRESSED:
        sjog_jog_position_changed(JOG_PUSHED);
        break;
     case SONYPI_EVENT_JOGDIAL_UP_PRESSED:
        sjog_jog_position_changed(JOG_PUSHED);
        break;
     case SONYPI_EVENT_JOGDIAL_PRESSED:
	sjog_jog_position_changed(JOG_PUSHED);
	break;
     case SONYPI_EVENT_JOGDIAL_BACK_PRESSED:
	sjog_jog_position_changed(JOG_BACK);
	break;

        /* and the ones it should probably handle ...

           case SONYPI_EVENT_JOGDIAL_RELEASED:
           break;
           case SONYPI_EVENT_CAPTURE_PRESSED:
           break;
           case SONYPI_EVENT_CAPTURE_RELEASED:
           break;
           case SONYPI_EVENT_CAPTURE_PARTIALPRESSED:
           break;
           case SONYPI_EVENT_CAPTURE_PARTIALRELEASED:
           break;
           case SONYPI_EVENT_FNKEY_ESC:
           break;
           case SONYPI_EVENT_FNKEY_F1:
           break;
           case SONYPI_EVENT_FNKEY_F2:
           break;
           case SONYPI_EVENT_FNKEY_F3:
           break;
           case SONYPI_EVENT_FNKEY_F4:
           break;
           case SONYPI_EVENT_FNKEY_F5:
           break;
           case SONYPI_EVENT_FNKEY_F6:
           break;
           case SONYPI_EVENT_FNKEY_F7:
           break;
           case SONYPI_EVENT_FNKEY_F8:
           break;
           case SONYPI_EVENT_FNKEY_F9:
           break;
           case SONYPI_EVENT_FNKEY_F10:
           break;
           case SONYPI_EVENT_FNKEY_F11:
           break;
           case SONYPI_EVENT_FNKEY_F12:
           break;
           case SONYPI_EVENT_FNKEY_1:
           break;
           case SONYPI_EVENT_FNKEY_2:
           break;
           case SONYPI_EVENT_FNKEY_D:
           break;
           case SONYPI_EVENT_FNKEY_E:
           break;
           case SONYPI_EVENT_FNKEY_F:
           break;
           case SONYPI_EVENT_FNKEY_S:
           break;
           case SONYPI_EVENT_FNKEY_B:
           break;
           case SONYPI_EVENT_BLUETOOTH_PRESSED:
           break;
         */
   }

}
