#include "sjog_spic.h"

void
sjog_spic_init()
{

   /* open spic device */
   if ((spic_fd = open(SPIC_DEVICE, O_RDONLY)) < 0)
   {
      fprintf(stderr, "Could not open %s. Insert module spicdriver first.\n",
              SPIC_DEVICE);
      exit(1);
   }

}

gboolean
sjog_spic_read(gpointer * data)
{

   gint jog = 0;

#ifdef DEBUG
   fprintf(stdout, "sjog_spic_read_jog: spic_fd=%d\n", spic_fd);
#endif

   if (read(spic_fd, (gchar *) & jog, sizeof(gint)) < 0)
   {
      fprintf(stderr, "%s read error!\n", SPIC_DEVICE);
      close(spic_fd);
      exit(1);
   }

   sjog_jog_position_changed(jog);

   return TRUE;

}
