<?php
/******************************************************************************
 *  SiteBar 3 - The Bookmark Server for Personal and Team Use.                *
 *  Copyright (C) 2003,2004  Ondrej Brablc <http://brablc.com/mailto?o>       *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 ******************************************************************************/

define( 'MIN_VERSION',  '4.1.0');
define( 'CHARSET',      'charset=UTF-8');
define( 'CONTENT_TYPE', 'text/html; '.CHARSET);

if (version_compare(phpversion(), MIN_VERSION, '<'))
{
    die("Please use at least PHP $min_version, ".
        "or download SiteBar release 3.0.2!");
}

/******************************************************************************/

function reqVal($name, $mandatory=false)
{
    $is = reqChk($name);
    if ($mandatory && !reqChk($name))
    {
        die('Expected field "'. $name .'" was not filled!');
    }
    return $is?$_REQUEST[$name]:'';
}

function reqChk($name)
{
    return isset($_REQUEST[$name]);
}

/******************************************************************************/

class Skin extends ErrorHandler
{
    var $current = 'Modern';
    var $basedir = '';

    function & instance()
    {
        static $skin = null;
        if (!$skin)
        {
            $skin = new Skin();
        }

        return $skin;
    }

    function get()
    {
        $i =& Skin::instance();
        return $i->current;
    }

    function set($skin)
    {
        if ($skin)
        {
            $i =& Skin::instance();
            $i->current = $skin;
        }
    }

    function img($filename, $prefix='', $id='', $class=null)
    {
        $imgid = '';

        if ($prefix)
        {
            $imgid = ' id="i' . $prefix . $id . '" ';
        }

        return '<img'.($class?' class="'.$class.'"':'') . $imgid .
               ' src="'. Skin::imgsrc($filename) .'" alt="">';
    }

    function imgsrc($filename)
    {
        return Skin::path() . '/' . $filename . '.png';
    }

    function path()
    {
        static $i = null;
        if (!$i) $i =& Skin::instance();
        return $i->basedir . 'skins/'. Skin::get();
    }

    function setBaseDir($dir)
    {
        $i =& Skin::instance();
        $i->basedir = $dir;
    }
}

class Page extends ErrorHandler
{
    function title()
    {
        return 'SiteBar';
    }

    function baseurl()
    {
        static $baseurl = null;

        if ($baseurl === null)
        {
            $hostvar = isset($_SERVER['HTTP_HOST'])?'HTTP_HOST':'SERVER_NAME';
            $parts = explode('/',$_SERVER['SERVER_PROTOCOL']);
            $proto = array_shift($parts);
            $version = array_shift($parts);
            $dirs = explode('/', strtolower($proto).'://'.$_SERVER[$hostvar].$_SERVER['SCRIPT_NAME']);
            array_pop($dirs);
            $baseurl = implode('/', $dirs);
        }

        // Returns something like http://localhost/sitebar
        // If you have problems with some urls, you can hardcode it here:
        return $baseurl;
    }

    function isMSIE()
    {
        static $isMSIE = null;

        if ($isMSIE === null)
        {
            $isMSIE = strstr(safeVal($_SERVER,'HTTP_USER_AGENT'), 'MSIE');
        }

        return $isMSIE;
    }

    // Exclude Opera
    function isOPERA()
    {
        static $isOPERA = null;

        if ($isOPERA === null)
        {
            $isOPERA = strstr(safeVal($_SERVER,'HTTP_USER_AGENT'), 'Opera');
        }

        return $isOPERA;
    }

    function dragDropNode($nid)
    {
        if (Page::isOPERA())
        {
            return '';
        }

        return ' '.
            (Page::isMSIE()?'ondragstart':'onmousedown').
            '="return nodeDrag(event,'. $nid .')"'.
            ' onmouseup="return nodeDrop(event,'. $nid .')"';
    }

    function dragDropLink($nid, $lid)
    {
        if (Page::isOPERA())
        {
            return '';
        }

        return ' '.
            (Page::isMSIE()?'ondragstart':'onmousedown').
            '="return linkDrag(event,'. $lid .')"'.
            ' onmouseup="return nodeDrop(event,'. $nid .','. $lid . ')"';
    }

    function target()
    {
        static $trg = null;

        if ($trg === null)
        {
            $target = (Page::isMSIE()||Page::isOPERA()?'_main':'_content');
            if (isset($_REQUEST['target'])) $target = $_REQUEST['target'];
            $trg = ' target="'.$target.'"';
        }
        return $trg;
    }

    function head($title, $bodyClass=null, $script=null, $onLoad=null, $meta=null)
    {
        // Do not change document type!
        // Any newer version would require changes of JavaScript library.
        // media="All" is used to hide the styles from Netscape 4.x

        $target = '';
        if (isset($_REQUEST['target'])) $target = $_REQUEST['target'];
        $mode= '';
        if (isset($_REQUEST['mode'])) $mode = $_REQUEST['mode'];

        // Can be commented if properly configured HTTP server
        // Apache: AddDefaultCharset, should be either empty or UTF-8
        header("Content-Type: ".CONTENT_TYPE);

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
    "http://www.w3.org/TR/REC-html40/loose.dtd">

<html>
<head>
    <title>:: <?php echo Page::title()?> :: <?php echo T($title)?></title>
    <meta http-equiv="Content-Type" content="<?php echo CONTENT_TYPE?>">
<?php echo $meta?>
    <link rel="Shortcut Icon" href="<?php echo Skin::path()?>/root_transparent.png">
    <link rel="StyleSheet"    href="<?php echo Skin::path()?>/sitebar.css" type="text/css" media="all">
    <link rel="Author"        href="http://brablc.com/">
    <script type="text/javascript">
        var langFolder = '<?php echo T('Folder found')?>';
        var langLink = '<?php echo T('Link found')?>';
        var langDesc = '<?php echo T('Desc')?>';
        var langName = '<?php echo T('Name')?>';
        var langFindNext = '<?php echo T('Find next?')?>';
    </script>
    <script src="inc/sitebar.js" type="text/javascript"></script>
    <script type="text/javascript">
        setSkinDir('<?php echo Skin::path()?>');
        setParams('<?php echo $target?>','<?php echo $mode?>');
        <?php echo $script?>
    </script>
</head>
<body <?php echo ($bodyClass?'class="'.$bodyClass.'"':'')?><?php echo ($onLoad?' onLoad="'.$onLoad.'"':'')?> onmouseup="cancelDragging()">
<?php
    }

    function foot()
    {
?>
</body>
</html>
<?php
    }

    /* static */ function quoteValue($value)
    {
        $q = htmlspecialchars($value);
        return str_replace("\r\n",' ',str_replace("&amp;","&",$q));
    }
}
?>
