# coding:utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search
   shared document structure

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007,
   2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Structure
  class Split_text_object
    include SiSU_Viz
    #include SiSU_HTML_Format_type
    @@dp=nil
    attr_reader :format,:text,:ocn,:scroll_lev_para_ocn,:seg_lev_para_ocn,:lev_para_ocn
    def initialize(md,para)
      @md,@para=md,para
      @format,@ocn='null','null'
      #@format,@ocn=nil,nil
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def lev_segname_para_ocn
      if @para =~/^#{Mx[:lv_o]}\d:.+?#{Mx[:id_o]}~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        if @para[/^#{Mx[:lv_o]}([1-6]):(\S+?)#{Mx[:lv_c]}\s*(\S.+?)#{Mx[:id_o]}~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,segname,@text,@ocn=$1,$2,$3,$4
          #@format="#@format:#{segname}" #
        elsif @para[/^#{Mx[:lv_o]}([1-6]):#{Mx[:lv_c]}\s*(\S.+?)#{Mx[:id_o]}~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,@text,@ocn=$1,$2,$3
        end
      else
        if @para[/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]}#{Mx[:gl_bullet]})\s*(.+?)#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,@text,@ocn=$1,$2,$3,$4 #watch and work on
        elsif @para[/^(#{Mx[:gl_bullet]})\s*(.+?)#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,@text,@ocn=$1,$2,$3
        elsif  @para[/#{Mx[:pa_o]}:(i[1-9])#{Mx[:pa_c]}\s*(.+?)#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,@text,@ocn=$1,$2,$3 #consider
        elsif @para[/#{Mx[:gr_o]}(code|alt|verse|group)#{Mx[:gr_c]}(.+?)#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @format,@text,@ocn=$1,$2,$3
        elsif @para[/(.+?)#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/m]
          @text,@ocn=$1,$2 #,$3
        end
        if @para !~/#{Mx[:id_o]}~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$|^$/ #added 2002w06
          @text=@para[/(.+?)/m,1]
        end
        if @para[/^#{Mx[:lv_o]}(\d):\S*?#{Mx[:lv_c]}\s+(.+)/m]
          @format,@text=$1,$2
        end
      end
      @format="#@format:#{segname}" if @format =~/^[1-6]$/
      self
    end
    def html_seg
      lev_segname_para_ocn
      @seg_lev_para_ocn=if @para[/.+#{Mx[:id_o]}~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]
        SiSU_HTML_Format_type::Format_seg.new(@md,@format,@text,@ocn)
      end
      self
    end
    def html_scroll
      lev_segname_para_ocn
      @scroll_lev_para_ocn=if @para[/.+#{Mx[:id_o]}~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/]
        SiSU_HTML_Format_type::Format_scroll.new(@md,@format,@text,@ocn)
      end
      self
    end
    def xml
      require "#{SiSU_lib}/shared_xml"
      lev_segname_para_ocn
      @lev_para_ocn=if @para =~/.+#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,"x#@ocn")
      else
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,"#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}")
      end
      self
    end
    def odt
      lev_segname_para_ocn
      @lev_para_ocn=if @para =~/.+#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        SiSU_ODF_format::Format_text_object.new(format,@text,@ocn)
      else
        SiSU_ODF_format::Format_text_object.new(format,@text,"#{Mx[:id_o]}~(\d+);[um]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}")
      end
      self

    end
    def txt
      lev_segname_para_ocn
      #format=@format.dup
      @lev_para_ocn=if @para =~/.+#{Mx[:id_o]}~\d+;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        Format::Format_text_object.new(@format,@text,@ocn)
      else
        Format::Format_text_object.new(@format,@text,"#{Mx[:id_o]}~(\d+);[um]\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}")
      end
      self
    end
  end
end
__END__
