# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html generation, html pre-processing

=end
require "#{SiSU_lib}/param"
module SiSU_Tune
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/html_format" #watch
  include SiSU_Env
  include SiSU_Screen
  @@line_mode=''
  @@endnote_array=[]
  @@endnote_call_counter=1
  @@table_align='<table summary='' width="96%" border="0" bgcolor="white" cellpadding="0" col="3">
<tr ...><td width="2%" align="right">
&nbsp\;</td>
<td width="94%" valign="top" align="justify">'
  @@table_align_close='</td>
<td width="4%" align="right" valign="top">
<font size="1" color="#777777">
&nbsp;&nbsp;&nbsp;</font> </td></tr></table>'
  @@counter,@@column,@columns=0,0,0
  class Output
    def initialize(data,md)
      @data,@md=data,md
      @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
    end
    def hard_output
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @filename_tune=my_make.file_tune
      data=[]
      @data.each{|x| x.strip; data << x if not x.empty?} #1.9 array?
      data.each do |para|
        @filename_tune.puts para, "\n" #if para !~/¡/u
      end
    end
    def marshal
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @marshal_tune=my_make.marshal_tune
      File.open(@marshal_tune,'w') {|f| Marshal.dump(@data.to_a,f)}
    end
  end
  class Clean_html
    def initialize(html='')
      @html=html
    end
    def clean
      @html.gsub!(/#{Mx[:gl_o]}(#[0-9]+)#{Mx[:gl_c]}/u,'&\1;')
      @html.gsub!(/#{Mx[:gl_o]}#([a-z]{2,4})#{Mx[:gl_c]}/u,'&\1;')
      @html.gsub!(/¢/u,'&cent;')    # &#162;
      @html.gsub!(/£/u,'&pound;')   # &#163;
      @html.gsub!(/¥/u,'&yen;')     # &#165;
      @html.gsub!(/§/u,'&sect;')    # &#167;
      @html.gsub!(/©/u,'&copy;')    # &#169;
      @html.gsub!(/ª/u,'&ordf;')    # &#170;
      @html.gsub!(/«/u,'&laquo;')   # &#171;
      @html.gsub!(/®/u,'&reg;')     # &#174;
      @html.gsub!(/°/u,'&deg;')     # &#176;
      @html.gsub!(/±/u,'&plusmn;')  # &#177;
      @html.gsub!(/²/u,'&sup2;')    # &#178;
      @html.gsub!(/³/u,'&sup3;')    # &#179;
      @html.gsub!(/µ/u,'&micro;')   # &#181;
      @html.gsub!(/¶/u,'&para;')    # &#182;
      @html.gsub!(/¹/u,'&sup1;')    # &#185;
      @html.gsub!(/º/u,'&ordm;')    # &#186;
      @html.gsub!(/»/u,'&raquo;')   # &#187;
      @html.gsub!(/¼/u,'&frac14;')  # &#188;
      @html.gsub!(/½/u,'&frac12;')  # &#189;
      @html.gsub!(/¾/u,'&frac34;')  # &#190;
      @html.gsub!(/×/u,'&times;')   # &#215;
      @html.gsub!(/÷/u,'&divide;')  # &#247;
      @html.gsub!(/¿/u,'&iquest;')  # &#191;
      @html.gsub!(/À/u,'&Agrave;')  # &#192;
      @html.gsub!(/Á/u,'&Aacute;')  # &#193;
      @html.gsub!(/Â/u,'&Acirc;')   # &#194;
      @html.gsub!(/Ã/u,'&Atilde;')  # &#195;
      @html.gsub!(/Ä/u,'&Auml;')    # &#196;
      @html.gsub!(/Å/u,'&Aring;')   # &#197;
      @html.gsub!(/Æ/u,'&AElig;')   # &#198;
      @html.gsub!(/Ç/u,'&Ccedil;')  # &#199;
      @html.gsub!(/È/u,'&Egrave;')  # &#200;
      @html.gsub!(/É/u,'&Eacute;')  # &#201;
      @html.gsub!(/Ê/u,'&Ecirc;')   # &#202;
      @html.gsub!(/Ë/u,'&Euml;')    # &#203;
      @html.gsub!(/Ì/u,'&Igrave;')  # &#204;
      @html.gsub!(/Í/u,'&Iacute;')  # &#205;
      @html.gsub!(/Î/u,'&Icirc;')   # &#206;
      @html.gsub!(/Ï/u,'&Iuml;')    # &#207;
      @html.gsub!(/Ð/u,'&ETH;')     # &#208;
      @html.gsub!(/Ñ/u,'&Ntilde;')  # &#209;
      @html.gsub!(/Ò/u,'&Ograve;')  # &#210;
      @html.gsub!(/Ó/u,'&Oacute;')  # &#211;
      @html.gsub!(/Ô/u,'&Ocirc;')   # &#212;
      @html.gsub!(/Õ/u,'&Otilde;')  # &#213;
      @html.gsub!(/Ö/u,'&Ouml;')    # &#214;
      @html.gsub!(/Ø/u,'&Oslash;')  # &#216;
      @html.gsub!(/Ù/u,'&Ugrave;')  # &#217;
      @html.gsub!(/Ú/u,'&Uacute;')  # &#218;
      @html.gsub!(/Û/u,'&Ucirc;')   # &#219;
      @html.gsub!(/Ü/u,'&Uuml;')    # &#220;
      @html.gsub!(/Ý/u,'&Yacute;')  # &#221;
      @html.gsub!(/Þ/u,'&THORN;')   # &#222;
      @html.gsub!(/ß/u,'&szlig;')   # &#223;
      @html.gsub!(/à/u,'&agrave;')  # &#224;
      @html.gsub!(/á/u,'&aacute;')  # &#225;
      @html.gsub!(/â/u,'&acirc;')   # &#226;
      @html.gsub!(/ã/u,'&atilde;')  # &#227;
      @html.gsub!(/ä/u,'&auml;')    # &#228;
      @html.gsub!(/å/u,'&aring;')   # &#229;
      @html.gsub!(/æ/u,'&aelig;')   # &#230;
      @html.gsub!(/ç/u,'&ccedil;')  # &#231;
      @html.gsub!(/è/u,'&egrave;')  # &#232;
      @html.gsub!(/é/u,'&eacute;')  # &#233;
      @html.gsub!(/ê/u,'&ecirc;')   # &#234;
      @html.gsub!(/ë/u,'&euml;')    # &#235;
      @html.gsub!(/ì/u,'&igrave;')  # &#236;
      @html.gsub!(/í/u,'&iacute;')  # &#237;
      @html.gsub!(/î/u,'&icirc;')   # &#238;
      @html.gsub!(/ï/u,'&iuml;')    # &#239;
      @html.gsub!(/ð/u,'&eth;')     # &#240;
      @html.gsub!(/ñ/u,'&ntilde;')  # &#241;
      @html.gsub!(/ò/u,'&ograve;')  # &#242;
      @html.gsub!(/ó/u,'&oacute;')  # &#243;
      @html.gsub!(/ô/u,'&ocirc;')   # &#244;
      @html.gsub!(/õ/u,'&otilde;')  # &#245;
      @html.gsub!(/ö/u,'&ouml;')    # &#246;
      @html.gsub!(/ø/u,'&oslash;')  # &#248;
      @html.gsub!(/ù/u,'&ugrave;')  # &#250;
      @html.gsub!(/ú/u,'&uacute;')  # &#251;
      @html.gsub!(/û/u,'&ucirc;')   # &#252;
      @html.gsub!(/ü/u,'&uuml;')    # &#253;
      @html.gsub!(/þ/u,'&thorn;')   # &#254;
      @html.gsub!(/ÿ/u,'&yuml;')    # &#255;
      @html.gsub!(/ý/u,'&yacute;')
      @html
    end
  end
  class Tune
    @@dp=nil
    def initialize(data,md)
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @env=SiSU_Env::Info_env.new(@md.fns)
      @sys=SiSU_Env::System_call.new
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      @env=SiSU_Env::Info_env.new(@md.fns)
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      #@utf8=SiSU_character_encode::UTF8 #.new
    end
    def songsheet
      begin
        @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
        tell=SiSU_Screen::Ansi.new(@md.cmd,'Tune')
        tell.txt_grey unless @md.cmd =~/q/
        data=Tune.new(@data,@md).endnotes_html
        data=Tune.new(data,@md).url_markup
        data=Tune.new(data,@md).markup
        if @md.cmd =~/M/  #Hard Output Tune Optional on/off here
          data=Output.new(data,@md).hard_output
          Output.new(data,@md).marshal
        end
        tuned=Tune.new(@data,@md).output
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
    def para_numbers
      data=@data
      @tuned_file=[]
      data.each do |para|
        para.gsub!(/#{Mx[:lv_o]}\d:(\S?)#{Mx[:lv_c]}/,'\0<a name="H#\1">#\1.</a>&nbsp;')
        @tuned_file << para
      end
    end
    def markup
      @tuned_file=[]
      @data.each do |para|
        #@utf8.new(para).html
        #@utf8.html(@para)
        para.gsub!(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;')
        para.gsub!(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;')
        para.gsub!(/#{Mx[:br_line]}|#{Mx[:br_nl]}/,'<br />')
        para.gsub!(/(?:\s*#{Mx[:br_page]}\s*|\s*#{Mx[:br_page_new]}\s*)+/m,'<p><hr width=90% /></p>') # else clean ''
        para.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'<b>\1</b>')
        para.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'<i>\1</i>')
        para.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'<u>\1</u>')
        para.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,'<sup>\1</sup>')
        para.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,'<sub>\1</sub>')
        para.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>')
        para.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>')
        para.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>')
        para.gsub!(/#{Mx[:mk_o]}:name#(\S+?)#{Mx[:mk_c]}/,'<a name="\1"></a>')
        para.gsub!(/<(p|br)>/,'<\1 />')
        para=SiSU_Tune::Clean_html.new(para).clean
        @tuned_file << para
      end
    end
    def urls(data)
      @words=[]
      data.each do |word|
        @words << if word=~/\{(.+?)\}((?:https?|file|ftp)\S+|image)/
          if word =~/\{.+?\}(?:(?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?|image)[;.,]?(?:\s|$)/
            m,u,d=/\{(.+?)\}((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?|image)([;.,]?(?:\s|$))/.match(word).captures
          else m,u=/\{(.+?)\}((?:https?|file|ftp)\S+|image)/.match(word).captures
            d=''
          end
          case m
          when /\.png|\.jpg|\.gif|c=|\d+x\d+/
            w,h=/(\d+)x(\d+)/.match(m).captures if m =~/\d+x\d+/
            w=%{width="#{w}"} if w
            h=%{height="#{h}"} if h
            c=m[/"(.+?)"/m,1]
            caption=%{<br /><p class="caption">#{c}</p>} if c
            png=m.scan(/\S+/)[0]
            image_path=if @md.fns =~/\.-ss[tm]$/; @env.url.images_external
            else                                  @env.url.images_local
            end
            ins=if u \
            and u.strip !~/^image$/
              %{<a href="#{u}"><img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0"></a>#{caption}}
            else %{<img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0">#{caption}}
            end
            word.gsub!(/\{.+?\}((?:https?|file|ftp)\S+|image)/,ins)
          else
            link=m[/(.+)/m]
            png=m.scan(/\S+/)[0].strip
            link=link.strip
            ins=%{<a href="#{u}">#{link}</a>#{d}}
            word.gsub!(/\{.+?\}(?:https?|file|ftp)\S+/,ins)
          end
          word
        else word
        end
        word
      end
      @words=@words.join(' ')
    end
    def url_markup
      data=@data
      @tuned_file=[]
      data.each do |para|
        #para.gsub!(/#{Mx[:mk_o]}name#(\S+?)#{Mx[:mk_c]}/,'<a name="\1"></a>')
        para.gsub!(/<-#>/,'')
        #para.gsub!(/<(p|br)>/,'<\1 />')
        unless para =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
          if para =~/<::\s+/ #watch
            para.gsub!(/<::\s+(\S+?)\s+!>/,
              %{<img src="#{@env.url.images}/c_\\1.png" alt="\\1" width="14" height="14" align="bottom" border="0">})
          end
          if para =~/<:image\s+/
            para.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
              %{<a href="\\1"><img src="#{@env.url.images_local}/\\2" \\3 \\4 naturalsizeflag="0" align="bottom" border="0"></a>})
            para.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+>/,
              %{<a href="\\1"><img src="#{@env.url.images_local}/\\2" naturalsizeflag="0" align="bottom" border="0"></a>})
            para.gsub!(/<:image\s+(\S+)\s+(\S+)\s+(\S+)\s+>/,
              %{<img src="#{@env.url.images_local}/\\1" \\2 \\3 naturalsizeflag="0" align="bottom" border="0">})
            para.gsub!(/<:image\s+(\S+)\s+>/,
              %{<img src="#{@env.url.images_local}/\\1" naturalsizeflag="0" align="bottom" border="0">})
          end
          if para =~/\{.+?\}((?:https?|file|ftp)\S+|image)/
            @word_mode=para.scan(/\{.+?\}(?:(?:https?|file|ftp)\S+|image)|(?:#{Mx[:gl_o]}\S+?#{Mx[:gl_c]})+|\S+/u)
            words=urls(@word_mode)
            para.gsub!(/.+/m,words)
          end
          if (para !~/^#{Mx[:meta_o]}|^#{Mx[:gr_o]}code#{Mx[:gr_c]}/)
            para.gsub!(/\\copyright/i,%{<sup>&copy;</sup>})
            if (para !~/\<:ad\s+\.\.\//)
              para.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*!\>/,
                %{\n<center><a href="http:\/\/\\1" target="external"><img src="#{@env.url.images_local}/\\2" alt="\\3"></a></center>\n})
            else
              para.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*\>/,
                %{\n<center><a href="\\1" target="_top"><img src="#{@env.url.images_local}/\\2" alt="\\3"></a></center>\n})
            end
            para.gsub!(/!pick/, %{<img border="0" height="15" width="15" src="#{@env.url.images}/#{@vz.icon_choice}" alt="stellar">})
            para.gsub!(/!new/, %{&nbsp;<img border="0" height="15" width="15" src="#{@env.url.images}/#{@vz.icon_new}" alt="new">})
            para.gsub!(/<:h(.{1,7}?)>/,'<a href="#h\1">\1</a>')
            para.gsub!(/<:to(\d{1,7}?)>/,'<a href="#to\1">to&nbsp;{&nbsp;\1&nbsp;}</a> ')
            if para =~/\b\S+\@\S+?\.\S+/ \
            and para !~/(\"\S+\@\S+?\.\S+\"|>\S+\@\S+?\.\S+?<)/
              para.gsub!(/([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)/,'&lt;<a href="mailto:\1">\1</a>&gt;')
            end
            para.gsub!(/\b[_\\]((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,'<a href="\1" target="_top">\1</a>\2') #http ftp matches escaped, no decoration
            para.gsub!(/((?:^|\s)[}])((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?:\s|$))/,'\1<a href="\2" target="_top">\2</a>\3') #special case \{ e.g. \}http://url
            para.gsub!(/(^|#{Mx[:gl_c]}|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"><\s]+?)([;.,]?(?=\s|$))/,%{\\1#{@url_brace.xml_open}<a href="\\2" target="_top">\\2</a>#{@url_brace.xml_close}\\3}) #http ftp matches with decoration
            if para =~/..\/\S+/ \
            and para !~/(\"..\/\S+?\"|>\s*..\/\S+<)/
              para.gsub!(/(\.\.\/\S+)/,'<a href="\1">\1</a>')
            end
            para.gsub!(/<a href="\.\.\//,%{<a href="#{@vz.url_site}/})
          end
        else
          para.gsub!(/(^|[^}])_</m,'\1&lt;'); para.gsub!(/(^|[^}])_>/m,'\1&gt;') #code-block: angle brackets special characters
          para.gsub!(/(^|[^}])_</m,'\1&lt;'); para.gsub!(/(^|[^}])_>/m,'\1&gt;')
        end
        @tuned_file << para
      end
    end
    def endnotes_html
      data=@data
      @tuned_file=[]
      data.each do |para|
        unless para =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
          para.gsub!(/(#{Mx[:en_a_o]}|#{Mx[:en_b_o]})(\d+)\s+(.+?) #{Mx[:id_o]}#@dp#{Mx[:id_c]}(#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/,
            '&nbsp;<a name="-\2" href="#_\2">&nbsp;<sup>\2</sup>&nbsp;</a> ' +  #note- endnote-
            '\1\2 <a name="_\2" href="#-\2">&nbsp;<sup>\2.</sup></a> \3 \4') #endnote- note- (careful may have switched)
          para.gsub!(/(#{Mx[:en_b_o]})([*+]\d+)\s+(.+?) #{Mx[:id_o]}#@dp#{Mx[:id_c]}(#{Mx[:en_b_c]})/,
            '&nbsp;<a name="-\2" href="#_\2">&nbsp;<sup>\2</sup>&nbsp;</a> ' +  #note- endnote-
            '\1\2 <a name="_\2" href="#-\2">&nbsp;<sup>\2.</sup></a> \3 \4') #endnote- note- (careful may have switched)
          para.gsub!(/(#{Mx[:en_a_o]})([*+]+)\s+(.+?) #{Mx[:id_o]}#@dp#{Mx[:id_c]}(#{Mx[:en_a_c]})/,
            '&nbsp;<a name="-\2" href="#_\2">&nbsp;<sup>\2</sup>&nbsp;</a> ' +  #note- endnote-
            '\1\2 <a name="_\2" href="#-\2">&nbsp;<sup>\2</sup></a> \3 \4') #endnote- note- (careful may have switched)
        end
        @tuned_file << para
      end
    end
    def output
      data=@data
      @tuned_file=[]
      data.each do |para|
        para.strip!
        para.chomp!
        @tuned_file << para
      end
      @tuned_file << "\n<EOF>" if (@md.fns =~/\.sst0/) #remove
      @tuned_file
    end
  end
end
__END__
