=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module  SiSU_DB 
  require SiSU_lib + '/db_columns'
  require SiSU_lib + '/db_tests'
  require SiSU_lib + '/db_create'
  require SiSU_lib + '/db_select'
  require SiSU_lib + '/db_indexes'
  require SiSU_lib + '/db_drop'
  require SiSU_lib + '/db_remove'
  require SiSU_lib + '/db_load_tuple'
  require SiSU_lib + '/db_import'
  class Column_size < SiSU_DB_columns::Column_size
  end
  class Test < SiSU_DB_tests::Test
  end
  class Create <SiSU_DB_create::Create #<SiSU_DB::Column_size
  end
  class Case <SiSU_DB_select::Case
  end
  class Index <SiSU_DB_index::Index                                           # create documents Indexes def initialize(opt,conn='',sql_type='')
  end
  class Drop <SiSU_DB_drop::Drop
  end
  class Remove <SiSU_DB_remove::Remove
  end
  class Load_tuple <SiSU_DB_tuple::Load_tuple                                  #% main database populate
  end
  class Import <SiSU_DB_import::Import #<SiSU_DB::Column_size                  #% main
  end
end
__END__
