/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.HibernateException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.DirectoryProviderHelper;
import org.hibernate.search.util.FileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSMasterDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static Log log = LogFactory.getLog(FSMasterDirectoryProvider.class);
    private FSDirectory directory;
    private int current;
    private String indexName;
    private Timer timer;
    private SearchFactory searchFactory;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactory searchFactory) {
        String source = DirectoryProviderHelper.getSourceDirectory("sourceBase", "source", directoryProviderName, properties);
        if (source == null) {
            throw new IllegalStateException("FSMasterDirectoryProvider requires a viable source directory");
        }
        log.debug((Object)("Source directory: " + source));
        File indexDir = DirectoryProviderHelper.determineIndexDir(directoryProviderName, properties);
        log.debug((Object)("Index directory: " + indexDir));
        String refreshPeriod = properties.getProperty("refresh", "3600");
        long period = Long.parseLong(refreshPeriod);
        log.debug((Object)("Refresh period " + period + " seconds"));
        period *= 1000L;
        try {
            boolean create = !indexDir.exists();
            this.indexName = indexDir.getCanonicalPath();
            if (create) {
                log.debug((Object)("Index directory '" + this.indexName + "' will be initialized"));
                indexDir.mkdir();
            }
            this.directory = FSDirectory.getDirectory((String)this.indexName, (boolean)create);
            if (create) {
                IndexWriter iw = new IndexWriter((Directory)this.directory, (Analyzer)new StandardAnalyzer(), create);
                iw.close();
            }
            if (new File(source, "current1").exists()) {
                this.current = 2;
            } else if (new File(source, "current2").exists()) {
                this.current = 1;
            } else {
                log.debug((Object)("Source directory for '" + this.indexName + "' will be initialized"));
                this.current = 1;
            }
            String currentString = Integer.valueOf(this.current).toString();
            File subDir = new File(source, currentString);
            FileHelper.synchronize(indexDir, subDir, true);
            new File(source, "current1").delete();
            new File(source, "current2").delete();
            new File(source, "current" + currentString).createNewFile();
            log.debug((Object)("Current directory: " + this.current));
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + directoryProviderName, (Throwable)e);
        }
        this.timer = new Timer();
        TriggerTask task = new TriggerTask(this.indexName, source, this);
        this.timer.scheduleAtFixedRate((TimerTask)task, period, period);
        this.searchFactory = searchFactory;
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSMasterDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSMasterDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.timer.cancel();
    }

    class CopyDirectory
    implements Runnable {
        private String source;
        private String destination;
        private volatile boolean inProgress;
        private Lock directoryProviderLock;
        private DirectoryProvider directoryProvider;

        public CopyDirectory(String source, String destination, DirectoryProvider directoryProvider) {
            this.source = source;
            this.destination = destination;
            this.directoryProvider = directoryProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            this.inProgress = true;
            if (this.directoryProviderLock == null) {
                this.directoryProviderLock = FSMasterDirectoryProvider.this.searchFactory.getLockableDirectoryProviders().get(this.directoryProvider);
                this.directoryProvider = null;
                FSMasterDirectoryProvider.this.searchFactory = null;
            }
            try {
                this.directoryProviderLock.lock();
                int oldIndex = FSMasterDirectoryProvider.this.current;
                int index = FSMasterDirectoryProvider.this.current == 1 ? 2 : 1;
                File sourceFile = new File(this.source);
                File destinationFile = new File(this.destination, Integer.valueOf(index).toString());
                try {
                    log.trace((Object)("Copying " + sourceFile + " into " + destinationFile));
                    FileHelper.synchronize(sourceFile, destinationFile, true);
                    FSMasterDirectoryProvider.this.current = index;
                }
                catch (IOException e) {
                    log.error((Object)("Unable to synchronize source of " + FSMasterDirectoryProvider.this.indexName), (Throwable)e);
                    this.inProgress = false;
                    this.directoryProviderLock.unlock();
                    this.inProgress = false;
                    return;
                }
                if (!new File(this.destination, "current" + oldIndex).delete()) {
                    log.warn((Object)("Unable to remove previous marker file from source of " + FSMasterDirectoryProvider.this.indexName));
                }
                try {
                    new File(this.destination, "current" + index).createNewFile();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to create current marker in source of " + FSMasterDirectoryProvider.this.indexName), (Throwable)e);
                }
            }
            finally {
                this.directoryProviderLock.unlock();
                this.inProgress = false;
            }
            log.trace((Object)("Copy for " + FSMasterDirectoryProvider.this.indexName + " took " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    class TriggerTask
    extends TimerTask {
        private ExecutorService executor = Executors.newSingleThreadExecutor();
        private CopyDirectory copyTask;

        public TriggerTask(String source, String destination, DirectoryProvider directoryProvider) {
            this.copyTask = new CopyDirectory(source, destination, directoryProvider);
        }

        public void run() {
            if (!this.copyTask.inProgress) {
                this.executor.execute(this.copyTask);
            } else {
                log.info((Object)("Skipping directory synchronization, previous work still in progress: " + FSMasterDirectoryProvider.this.indexName));
            }
        }
    }
}

