/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OgnlUtil.class);
    private ConcurrentHashMap<String, Object> expressions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class, BeanInfo> beanInfoCache = new ConcurrentHashMap();
    private TypeConverter defaultConverter;
    static boolean devMode = false;
    static boolean enableExpressionCache = true;

    @Inject
    public void setXWorkConverter(XWorkConverter conv) {
        this.defaultConverter = new OgnlTypeConverterWrapper(conv);
    }

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    @Inject(value="enableOGNLExpressionCache")
    public static void setEnableExpressionCache(String cache) {
        enableExpressionCache = "true".equals(cache);
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context) {
        this.setProperties(props, o, context, false);
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        if (props == null) {
            return;
        }
        Ognl.setTypeConverter(context, (TypeConverter)this.getTypeConverterFromContext(context));
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            String expression = entry.getKey();
            this.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public void setProperties(Map<String, ?> properties, Object o) {
        this.setProperties(properties, o, false);
    }

    public void setProperties(Map<String, ?> properties, Object o, boolean throwPropertyExceptions) {
        Map context = Ognl.createDefaultContext((Object)o);
        this.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context) {
        this.setProperty(name, value, o, context, false);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) {
        Ognl.setTypeConverter(context, (TypeConverter)this.getTypeConverterFromContext(context));
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        this.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public Object getRealTarget(String property, Map<String, Object> context, Object root) throws OgnlException {
        if ("top".equals(property)) {
            return root;
        }
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                for (Object target : cr) {
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && !OgnlRuntime.hasGetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && OgnlRuntime.getIndexedPropertyType((OgnlContext)((OgnlContext)context), target.getClass(), (String)property) == OgnlRuntime.INDEXED_PROPERTY_NONE) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException("Cannot figure out real target class", ex);
            }
            return null;
        }
        return root;
    }

    public void setValue(String name, Map<String, Object> context, Object root, Object value) throws OgnlException {
        Ognl.setValue((Object)this.compile(name), context, (Object)root, (Object)value);
    }

    public Object getValue(String name, Map<String, Object> context, Object root) throws OgnlException {
        return Ognl.getValue((Object)this.compile(name), context, (Object)root);
    }

    public Object getValue(String name, Map<String, Object> context, Object root, Class resultType) throws OgnlException {
        return Ognl.getValue((Object)this.compile(name), context, (Object)root, (Class)resultType);
    }

    public Object compile(String expression) throws OgnlException {
        if (enableExpressionCache) {
            Object o = this.expressions.get(expression);
            if (o == null) {
                o = Ognl.parseExpression((String)expression);
                this.expressions.put(expression, o);
            }
            return o;
        }
        return Ognl.parseExpression((String)expression);
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions) {
        PropertyDescriptor[] toPds;
        PropertyDescriptor[] fromPds;
        if (from == null || to == null) {
            LOG.warn("Attempting to copy from or to a null source. This is illegal and is bein skipped. This may be due to an error in an OGNL expression, action chaining, or some other event.", new String[0]);
            return;
        }
        TypeConverter conv = this.getTypeConverterFromContext(context);
        Map contextFrom = Ognl.createDefaultContext((Object)from);
        Ognl.setTypeConverter((Map)contextFrom, (TypeConverter)conv);
        Map contextTo = Ognl.createDefaultContext((Object)to);
        Ognl.setTypeConverter((Map)contextTo, (TypeConverter)conv);
        try {
            fromPds = this.getPropertyDescriptors(from);
            toPds = this.getPropertyDescriptors(to);
        }
        catch (IntrospectionException e) {
            LOG.error("An error occured", e, new String[0]);
            return;
        }
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor toPd : toPds) {
            toPdHash.put(toPd.getName(), toPd);
        }
        for (PropertyDescriptor fromPd : fromPds) {
            PropertyDescriptor toPd;
            if (fromPd.getReadMethod() == null) continue;
            boolean copy = true;
            if (exclusions != null && exclusions.contains(fromPd.getName())) {
                copy = false;
            } else if (inclusions != null && !inclusions.contains(fromPd.getName())) {
                copy = false;
            }
            if (!copy || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                Object expr = this.compile(fromPd.getName());
                Object value = Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from);
                Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
            }
            catch (OgnlException e) {
                // empty catch block
            }
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context) {
        this.copy(from, to, context, null, null);
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object source) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(source);
        return beanInfo.getPropertyDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public Map getBeanMap(Object source) throws IntrospectionException, OgnlException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        Map sourceMap = Ognl.createDefaultContext((Object)source);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.getPropertyDescriptors(source)) {
            String propertyName = propertyDescriptor.getDisplayName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                Object expr = this.compile(propertyName);
                Object value = Ognl.getValue((Object)expr, (Map)sourceMap, (Object)source);
                beanMap.put(propertyName, value);
                continue;
            }
            beanMap.put(propertyName, "There is no read method for " + propertyName);
        }
        return beanMap;
    }

    public BeanInfo getBeanInfo(Object from) throws IntrospectionException {
        return this.getBeanInfo(from.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        ConcurrentHashMap<Class, BeanInfo> concurrentHashMap = this.beanInfoCache;
        synchronized (concurrentHashMap) {
            BeanInfo beanInfo = this.beanInfoCache.get(clazz);
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                this.beanInfoCache.put(clazz, beanInfo);
            }
            return beanInfo;
        }
    }

    void internalSetProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        block3: {
            try {
                this.setValue(name, context, o, value);
            }
            catch (OgnlException e) {
                Throwable exception;
                Throwable reason = e.getReason();
                String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
                Throwable throwable = exception = reason == null ? e : reason;
                if (throwPropertyExceptions) {
                    throw new ReflectionException(msg, exception);
                }
                if (!devMode) break block3;
                LOG.warn(msg, exception, new String[0]);
            }
        }
    }

    TypeConverter getTypeConverterFromContext(Map<String, Object> context) {
        return this.defaultConverter;
    }
}

