/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.ClassInfo;
import com.google.doclava.Errors;
import com.google.doclava.ParameterInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.apicheck.AbstractMethodInfo;
import java.util.ArrayList;
import java.util.List;

public class ConstructorInfo
implements AbstractMethodInfo {
    private boolean mIsVarargs;
    private String mName;
    private String mType;
    private boolean mIsStatic;
    private boolean mIsFinal;
    private boolean mIsDeprecated;
    private String mScope;
    private List<String> mExceptions;
    private List<ParameterInfo> mParameters;
    private SourcePositionInfo mSourcePosition;
    private ClassInfo mClass;

    public ConstructorInfo(String name, String type, boolean isStatic, boolean isFinal, String deprecated, String scope, SourcePositionInfo pos, ClassInfo clazz) {
        this.mName = name;
        this.mType = type;
        this.mIsStatic = isStatic;
        this.mIsFinal = isFinal;
        this.mIsDeprecated = "deprecated".equals(deprecated);
        this.mScope = scope;
        this.mExceptions = new ArrayList<String>();
        this.mParameters = new ArrayList<ParameterInfo>();
        this.mSourcePosition = pos;
        this.mClass = clazz;
    }

    public void setDeprecated(boolean deprecated) {
        this.mIsDeprecated = deprecated;
    }

    public void addParameter(ParameterInfo pInfo) {
        this.mParameters.add(pInfo);
    }

    public void addException(String exec) {
        this.mExceptions.add(exec);
    }

    public String getHashableName() {
        StringBuilder result = new StringBuilder();
        result.append(this.name());
        for (ParameterInfo pInfo : this.mParameters) {
            result.append(":").append(pInfo.typeName());
        }
        return result.toString();
    }

    public SourcePositionInfo position() {
        return this.mSourcePosition;
    }

    public String name() {
        return this.mName;
    }

    public String qualifiedName() {
        String baseName = this.mClass != null ? this.mClass.qualifiedName() + "." : "";
        return baseName + this.name();
    }

    public String prettySignature() {
        String params = "";
        for (ParameterInfo pInfo : this.mParameters) {
            if (params.length() > 0) {
                params = params + ", ";
            }
            params = params + pInfo.typeName();
        }
        return this.qualifiedName() + '(' + params + ')';
    }

    public boolean isConsistent(ConstructorInfo mInfo) {
        boolean consistent = true;
        if (this.mIsFinal != mInfo.mIsFinal) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " has changed 'final' qualifier");
        }
        if (this.mIsStatic != mInfo.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " has changed 'static' qualifier");
        }
        if (!this.mScope.equals(mInfo.mScope)) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " changed scope from " + this.mScope + " to " + mInfo.mScope);
        }
        if (!this.mIsDeprecated == mInfo.mIsDeprecated) {
            consistent = false;
            Errors.error(Errors.CHANGED_DEPRECATED, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " has changed deprecation state");
        }
        for (String exec : this.mExceptions) {
            if (mInfo.mExceptions.contains(exec)) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " no longer throws exception " + exec);
            consistent = false;
        }
        for (String exec : mInfo.mExceptions) {
            if (this.mExceptions.contains(exec)) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Constructor " + mInfo.qualifiedName() + " added thrown exception " + exec);
            consistent = false;
        }
        return consistent;
    }

    public void setVarargs(boolean varargs) {
        this.mIsVarargs = varargs;
    }

    public boolean isVarArgs() {
        return this.mIsVarargs;
    }
}

