/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.AbstractData;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import java.io.IOException;
import java.util.Map;

public class DefaultDataContext
implements DataContext {
    private final Data rootData;
    private LocalVariable head = null;
    private boolean newScope = false;

    public DefaultDataContext(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("rootData is null");
        }
        this.rootData = data;
    }

    public Data getRootData() {
        return this.rootData;
    }

    public void pushVariableScope() {
        if (this.newScope) {
            throw new IllegalStateException("PushVariableScope called twice with no variables declared in between.");
        }
        this.newScope = true;
    }

    public void popVariableScope() {
        if (this.newScope) {
            this.newScope = false;
        } else {
            this.head = this.head.nextScope;
        }
    }

    public void createLocalVariableByValue(String name, String value) {
        this.createLocalVariableByValue(name, value, EscapeMode.ESCAPE_NONE);
    }

    public void createLocalVariableByValue(String name, String value, EscapeMode mode) {
        LocalVariable local = this.createLocalVariable(name);
        local.value = value;
        local.isPath = false;
        local.setEscapeMode(mode);
    }

    public void createLocalVariableByValue(String name, String value, boolean isFirst, boolean isLast) {
        LocalVariable local = this.createLocalVariable(name);
        local.value = value;
        local.isPath = false;
        local.isFirst = isFirst;
        local.isLast = isLast;
    }

    public void createLocalVariableByPath(String name, String path) {
        LocalVariable local = this.createLocalVariable(name);
        local.value = path;
        local.isPath = true;
    }

    private LocalVariable createLocalVariable(String name) {
        if (this.head == null && !this.newScope) {
            throw new IllegalStateException("Must call pushVariableScope before creating local variable.");
        }
        if (!this.newScope && this.head != null && name.equals(this.head.name)) {
            this.head.isFirst = true;
            this.head.isLast = true;
            this.head.node = null;
            return this.head;
        }
        LocalVariable local = new LocalVariable();
        local.name = name;
        local.next = this.head;
        if (this.newScope) {
            local.nextScope = this.head;
            this.newScope = false;
        } else {
            local.nextScope = this.head != null ? this.head.nextScope : null;
        }
        this.head = local;
        return local;
    }

    public Data findVariable(String name, boolean create) {
        return this.findVariable(name, create, this.head);
    }

    public EscapeMode findVariableEscapeMode(String name) {
        Data var = this.findVariable(name, false);
        if (var == null) {
            return EscapeMode.ESCAPE_NONE;
        }
        return var.getEscapeMode();
    }

    private Data findVariable(String name, boolean create, LocalVariable start) {
        String firstChunk = name;
        int dot = name.indexOf(46);
        if (dot != -1) {
            firstChunk = name.substring(0, dot);
        }
        LocalVariable curr = start;
        while (curr != null) {
            if (curr.name.equals(firstChunk)) {
                if (curr.isPath) {
                    if (curr.node == null) {
                        curr.node = this.findVariable(curr.value, create, curr.nextScope);
                        if (curr.node == null) {
                            return null;
                        }
                    }
                    if (dot == -1) {
                        return curr.node;
                    }
                    if (create) {
                        return curr.node.createChild(name.substring(dot + 1));
                    }
                    return curr.node.getChild(name.substring(dot + 1));
                }
                if (dot == -1) {
                    return curr;
                }
                if (create) {
                    throw new IllegalStateException("Cannot create children of a local literal variable");
                }
                return null;
            }
            curr = curr.next;
        }
        if (create) {
            return this.rootData.createChild(name);
        }
        return this.rootData.getChild(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalVariable
    extends AbstractData {
        LocalVariable next;
        LocalVariable nextScope;
        String name;
        String value;
        boolean isPath;
        Data node = null;
        boolean isFirst = true;
        boolean isLast = true;

        private LocalVariable() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getFullPath() {
            return this.name;
        }

        @Override
        public void setAttribute(String key, String value) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public String getAttribute(String key) {
            return null;
        }

        @Override
        public boolean hasAttribute(String key) {
            return false;
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public Iterable<Map.Entry<String, String>> getAttributes() {
            return null;
        }

        @Override
        public Data getRoot() {
            return null;
        }

        @Override
        public Data getParent() {
            return null;
        }

        @Override
        public boolean isFirstSibling() {
            return this.isFirst;
        }

        @Override
        public boolean isLastSibling() {
            return this.isLast;
        }

        @Override
        public Data getNextSibling() {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public Iterable<? extends Data> getChildren() {
            return null;
        }

        @Override
        public Data getChild(String path) {
            return null;
        }

        @Override
        public Data createChild(String path) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void removeTree(String path) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(String sourcePath, String destinationPath) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(String sourcePath, Data destination) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void setSymlink(Data symLink) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public Data getSymlink() {
            return this;
        }

        @Override
        public void copy(String toPath, Data from) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void copy(Data from) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public String getValue(String path, String defaultValue) {
            throw new UnsupportedOperationException("Not allowed on local variables.");
        }

        @Override
        public void write(Appendable out, int indent) throws IOException {
            for (int i = 0; i < indent; ++i) {
                out.append("  ");
            }
            out.append(this.getName()).append(" = ").append(this.getValue());
        }
    }
}

