/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.Db4oIOException;
import com.db4o.io.IoAdapter;
import com.db4o.io.RandomAccessFileAdapter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SymbianIoAdapter
extends RandomAccessFileAdapter {
    private byte[] _seekBytes = new byte[500];
    private String _path;
    private long _pos;
    private long _length;

    protected SymbianIoAdapter(String string, boolean bl, long l, boolean bl2) throws Db4oIOException {
        super(string, bl, l, bl2);
        this._path = string;
        this._pos = 0L;
        this.setLength();
    }

    private void setLength() throws Db4oIOException {
        this._length = this.retrieveLength();
    }

    private long retrieveLength() throws Db4oIOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this._path, "r");
            long l = randomAccessFile.length();
            return l;
        }
        catch (IOException iOException) {
            throw new Db4oIOException(iOException);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                throw new Db4oIOException(iOException);
            }
        }
    }

    public SymbianIoAdapter() {
    }

    public IoAdapter open(String string, boolean bl, long l, boolean bl2) throws Db4oIOException {
        return new SymbianIoAdapter(string, bl, l, bl2);
    }

    public long getLength() throws Db4oIOException {
        this.setLength();
        return this._length;
    }

    public int read(byte[] byArray, int n) throws Db4oIOException {
        int n2 = super.read(byArray, n);
        this._pos += (long)n2;
        return n2;
    }

    public void write(byte[] byArray, int n) throws Db4oIOException {
        super.write(byArray, n);
        this._pos += (long)n;
        if (this._pos > this._length) {
            this.setLength();
        }
    }

    public void seek(long l) throws Db4oIOException {
        if (l > this._length) {
            this.setLength();
        }
        if (l > this._length) {
            int n = (int)(l - this._length);
            super.seek(this._length);
            this._pos = this._length;
            if (n < 500) {
                this.write(this._seekBytes, n);
            } else {
                this.write(new byte[n]);
            }
        }
        super.seek(l);
        this._pos = l;
    }
}

