/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgBlob;

class BlobProcessor
extends Thread {
    private ClientObjectContainer stream;
    private Queue4 queue = new NonblockingQueue();
    private boolean terminated = false;

    BlobProcessor(ClientObjectContainer clientObjectContainer) {
        this.stream = clientObjectContainer;
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(MsgBlob msgBlob) {
        Queue4 queue4 = this.queue;
        synchronized (queue4) {
            this.queue.add(msgBlob);
        }
    }

    synchronized boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Socket4 socket4 = this.stream.createParalellSocket();
            MsgBlob msgBlob = null;
            Object object = this.queue;
            // MONITORENTER : object
            msgBlob = (MsgBlob)this.queue.next();
            // MONITOREXIT : object
            while (msgBlob != null) {
                msgBlob.write(socket4);
                msgBlob.processClient(socket4);
                object = this.stream.blobLock;
                // MONITORENTER : object
                Queue4 queue4 = this.queue;
                // MONITORENTER : queue4
                msgBlob = (MsgBlob)this.queue.next();
                // MONITOREXIT : queue4
                if (msgBlob == null) {
                    this.terminated = true;
                    Msg.CLOSE_SOCKET.write(socket4);
                    try {
                        socket4.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : object
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

