/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.Db4oIOException;
import com.db4o.ext.Db4oDatabase;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.handlers.HandlerVersion;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.WriteBuffer;

public class UUIDFieldMetadata
extends VirtualFieldMetadata {
    private static final int LINK_LENGTH = 12;

    UUIDFieldMetadata(ObjectContainerBase objectContainerBase) {
        super(2, new LongHandler(objectContainerBase));
        this.setName("v4ouuid");
    }

    public void addFieldIndex(MarshallerFamily marshallerFamily, ClassMetadata classMetadata, StatefulBuffer statefulBuffer, Slot slot) throws FieldIndexException {
        boolean bl = slot == null;
        int n = statefulBuffer._offset;
        int n2 = statefulBuffer.readInt();
        long l = statefulBuffer.readLong();
        statefulBuffer._offset = n;
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)statefulBuffer.getStream();
        if (!(l != 0L && n2 != 0 || statefulBuffer.getID() <= 0 || bl)) {
            DatabaseIdentityIDAndUUID databaseIdentityIDAndUUID = this.readDatabaseIdentityIDAndUUID(localObjectContainer, classMetadata, slot, false);
            n2 = databaseIdentityIDAndUUID.databaseIdentityID;
            l = databaseIdentityIDAndUUID.uuid;
        }
        if (n2 == 0) {
            n2 = localObjectContainer.identity().getID(statefulBuffer.getTransaction());
        }
        if (l == 0L) {
            l = localObjectContainer.generateTimeStampId();
        }
        statefulBuffer.writeInt(n2);
        statefulBuffer.writeLong(l);
        if (bl) {
            this.addIndexEntry(statefulBuffer, new Long(l));
        }
    }

    private DatabaseIdentityIDAndUUID readDatabaseIdentityIDAndUUID(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, Slot slot, boolean bl) throws Db4oIOException {
        ClassMetadata classMetadata2;
        Buffer buffer = objectContainerBase.bufferByAddress(slot.address(), slot.length());
        if (bl && (classMetadata2 = ClassMetadata.readClass(objectContainerBase, buffer)) != classMetadata) {
            return null;
        }
        if (classMetadata.findOffset(buffer, this) == HandlerVersion.INVALID) {
            return null;
        }
        return new DatabaseIdentityIDAndUUID(buffer.readInt(), buffer.readLong());
    }

    public void delete(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) {
        ObjectContainerBase objectContainerBase;
        if (bl) {
            statefulBuffer.incrementOffset(this.linkLength());
            return;
        }
        statefulBuffer.incrementOffset(4);
        long l = statefulBuffer.readLong();
        if (l > 0L && (objectContainerBase = statefulBuffer.getStream()).maintainsIndices()) {
            this.removeIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), new Long(l));
        }
    }

    public boolean hasIndex() {
        return true;
    }

    public BTree getIndex(Transaction transaction) {
        this.ensureIndex(transaction);
        return super.getIndex(transaction);
    }

    protected void rebuildIndexForObject(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata, int n) throws FieldIndexException {
        DatabaseIdentityIDAndUUID databaseIdentityIDAndUUID = this.readDatabaseIdentityIDAndUUID(localObjectContainer, classMetadata, ((LocalTransaction)localObjectContainer.systemTransaction()).getCurrentSlotOfID(n), true);
        if (null == databaseIdentityIDAndUUID) {
            return;
        }
        this.addIndexEntry(localObjectContainer.getLocalSystemTransaction(), n, new Long(databaseIdentityIDAndUUID.uuid));
    }

    private void ensureIndex(Transaction transaction) {
        if (null == transaction) {
            throw new ArgumentNullException();
        }
        if (null != super.getIndex(transaction)) {
            return;
        }
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)transaction.container();
        SystemData systemData = localObjectContainer.systemData();
        if (systemData == null) {
            return;
        }
        this.initIndex(transaction, systemData.uuidIndexId());
        if (systemData.uuidIndexId() == 0) {
            systemData.uuidIndexId(super.getIndex(transaction).getID());
            localObjectContainer.getFileHeader().writeVariablePart(localObjectContainer, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void instantiate1(Transaction transaction, ObjectReference objectReference, Buffer buffer) {
        int n = buffer.readInt();
        ObjectContainerBase objectContainerBase = transaction.container();
        objectContainerBase.showInternalClasses(true);
        try {
            Db4oDatabase db4oDatabase = (Db4oDatabase)objectContainerBase.getByID2(transaction, n);
            if (db4oDatabase != null && db4oDatabase.i_signature == null) {
                objectContainerBase.activate(transaction, db4oDatabase, 2);
            }
            VirtualAttributes virtualAttributes = objectReference.virtualAttributes();
            virtualAttributes.i_database = db4oDatabase;
            virtualAttributes.i_uuid = buffer.readLong();
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    protected int linkLength() {
        return 12;
    }

    void marshall(Transaction transaction, ObjectReference objectReference, WriteBuffer writeBuffer, boolean bl, boolean bl2) {
        boolean bl3;
        VirtualAttributes virtualAttributes = objectReference.virtualAttributes();
        ObjectContainerBase objectContainerBase = transaction.container();
        boolean bl4 = bl2 && objectContainerBase.maintainsIndices();
        int n = 0;
        boolean bl5 = virtualAttributes != null && virtualAttributes.i_database == null ? true : (bl3 = !bl);
        if (bl3) {
            Db4oDatabase db4oDatabase = objectContainerBase.identity();
            if (db4oDatabase == null) {
                virtualAttributes = null;
            } else {
                if (virtualAttributes.i_database == null) {
                    virtualAttributes.i_database = db4oDatabase;
                    if (objectContainerBase instanceof LocalObjectContainer) {
                        virtualAttributes.i_uuid = objectContainerBase.generateTimeStampId();
                        bl4 = true;
                    }
                }
                if ((db4oDatabase = virtualAttributes.i_database) != null) {
                    n = db4oDatabase.getID(transaction);
                }
            }
        } else if (virtualAttributes != null) {
            n = virtualAttributes.i_database.getID(transaction);
        }
        writeBuffer.writeInt(n);
        if (virtualAttributes == null) {
            writeBuffer.writeLong(0L);
            return;
        }
        writeBuffer.writeLong(virtualAttributes.i_uuid);
        if (bl4) {
            this.addIndexEntry(transaction, objectReference.getID(), new Long(virtualAttributes.i_uuid));
        }
    }

    void marshallIgnore(WriteBuffer writeBuffer) {
        writeBuffer.writeInt(0);
        writeBuffer.writeLong(0L);
    }

    public final HardObjectReference getHardObjectReferenceBySignature(Transaction transaction, long l, byte[] byArray) {
        BTreeRange bTreeRange = this.search(transaction, new Long(l));
        Iterator4 iterator4 = bTreeRange.keys();
        while (iterator4.moveNext()) {
            FieldIndexKey fieldIndexKey = (FieldIndexKey)iterator4.current();
            HardObjectReference hardObjectReference = this.getHardObjectReferenceById(transaction, fieldIndexKey.parentID(), byArray);
            if (null == hardObjectReference) continue;
            return hardObjectReference;
        }
        return HardObjectReference.INVALID;
    }

    protected final HardObjectReference getHardObjectReferenceById(Transaction transaction, int n, byte[] byArray) {
        HardObjectReference hardObjectReference = transaction.container().getHardObjectReferenceById(transaction, n);
        if (hardObjectReference._reference == null) {
            return null;
        }
        VirtualAttributes virtualAttributes = hardObjectReference._reference.virtualAttributes(transaction);
        if (!Arrays4.areEqual(byArray, virtualAttributes.i_database.i_signature)) {
            return null;
        }
        return hardObjectReference;
    }

    public void defragField(MarshallerFamily marshallerFamily, BufferPair bufferPair) {
        bufferPair.copyID();
        bufferPair.incrementOffset(8);
    }

    static class DatabaseIdentityIDAndUUID {
        public int databaseIdentityID;
        public long uuid;

        public DatabaseIdentityIDAndUUID(int n, long l) {
            this.databaseIdentityID = n;
            this.uuid = l;
        }
    }
}

