/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.Rename;
import com.db4o.config.ObjectAttribute;
import com.db4o.config.ObjectClass;
import com.db4o.config.ObjectConstructor;
import com.db4o.config.ObjectField;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oException;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.KeySpec;
import com.db4o.foundation.KeySpecHashtable4;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.Config4Abstract;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReflectPlatform;
import com.db4o.reflect.ReflectClass;

public class Config4Class
extends Config4Abstract
implements ObjectClass,
DeepClone {
    private final Config4Impl _configImpl;
    private static final KeySpec CALL_CONSTRUCTOR = new KeySpec(TernaryBool.UNSPECIFIED);
    private static final KeySpec CLASS_INDEXED = new KeySpec(true);
    private static final KeySpec EXCEPTIONAL_FIELDS = new KeySpec(null);
    private static final KeySpec GENERATE_UUIDS = new KeySpec(false);
    private static final KeySpec GENERATE_VERSION_NUMBERS = new KeySpec(false);
    private static final KeySpec MAINTAIN_METACLASS = new KeySpec(true);
    private static final KeySpec MAXIMUM_ACTIVATION_DEPTH = new KeySpec(0);
    private static final KeySpec MINIMUM_ACTIVATION_DEPTH = new KeySpec(0);
    private static final KeySpec PERSIST_STATIC_FIELD_VALUES = new KeySpec(false);
    private static final KeySpec QUERY_ATTRIBUTE_PROVIDER = new KeySpec(null);
    private static final KeySpec STORE_TRANSIENT_FIELDS = new KeySpec(false);
    private static final KeySpec TRANSLATOR = new KeySpec(null);
    private static final KeySpec TRANSLATOR_NAME = new KeySpec(null);
    private static final KeySpec UPDATE_DEPTH = new KeySpec(0);
    private static final KeySpec WRITE_AS = new KeySpec(null);

    protected Config4Class(Config4Impl config4Impl, KeySpecHashtable4 keySpecHashtable4) {
        super(keySpecHashtable4);
        this._configImpl = config4Impl;
    }

    Config4Class(Config4Impl config4Impl, String string) {
        this._configImpl = config4Impl;
        this.setName(string);
    }

    public int adjustActivationDepth(int n) {
        TernaryBool ternaryBool = this.cascadeOnActivate();
        if (ternaryBool.definiteYes() && n < 2) {
            n = 2;
        }
        if (ternaryBool.definiteNo() && n > 1) {
            n = 1;
        }
        if (this.config().classActivationDepthConfigurable()) {
            int n2;
            int n3 = this.minimumActivationDepth();
            if (n3 != 0 && n < n3) {
                n = n3;
            }
            if ((n2 = this.maximumActivationDepth()) != 0 && n > n2) {
                n = n2;
            }
        }
        return n;
    }

    public void callConstructor(boolean bl) {
        this.putThreeValued(CALL_CONSTRUCTOR, bl);
    }

    String className() {
        return this.getName();
    }

    ReflectClass classReflector() {
        return this.config().reflector().forName(this.getName());
    }

    public void compare(ObjectAttribute objectAttribute) {
        this._config.put(QUERY_ATTRIBUTE_PROVIDER, objectAttribute);
    }

    Config4Field configField(String string) {
        Hashtable4 hashtable4 = this.exceptionalFieldsOrNull();
        if (hashtable4 == null) {
            return null;
        }
        return (Config4Field)hashtable4.get(string);
    }

    public Object deepClone(Object object) {
        return new Config4Class((Config4Impl)object, this._config);
    }

    public void enableReplication(boolean bl) {
        this.generateUUIDs(bl);
        this.generateVersionNumbers(bl);
    }

    public void generateUUIDs(boolean bl) {
        this._config.put(GENERATE_UUIDS, bl);
    }

    public void generateVersionNumbers(boolean bl) {
        this._config.put(GENERATE_VERSION_NUMBERS, bl);
    }

    public ObjectTranslator getTranslator() {
        ObjectTranslator objectTranslator = (ObjectTranslator)this._config.get(TRANSLATOR);
        if (objectTranslator != null) {
            return objectTranslator;
        }
        String string = this._config.getAsString(TRANSLATOR_NAME);
        if (string == null) {
            return null;
        }
        try {
            objectTranslator = this.newTranslatorFromReflector(string);
        }
        catch (RuntimeException runtimeException) {
            try {
                objectTranslator = this.newTranslatorFromPlatform(string);
            }
            catch (Exception exception) {
                throw new Db4oException(exception);
            }
        }
        this.translate(objectTranslator);
        return objectTranslator;
    }

    private ObjectTranslator newTranslatorFromPlatform(String string) throws InstantiationException, IllegalAccessException {
        return (ObjectTranslator)ReflectPlatform.forName(string).newInstance();
    }

    private ObjectTranslator newTranslatorFromReflector(String string) {
        return (ObjectTranslator)this.config().reflector().forName(string).newInstance();
    }

    public void indexed(boolean bl) {
        this._config.put(CLASS_INDEXED, bl);
    }

    public boolean indexed() {
        return this._config.getAsBoolean(CLASS_INDEXED);
    }

    Object instantiate(ObjectContainerBase objectContainerBase, Object object) {
        return ((ObjectConstructor)this._config.get(TRANSLATOR)).onInstantiate(objectContainerBase, object);
    }

    boolean instantiates() {
        return this.getTranslator() instanceof ObjectConstructor;
    }

    public void maximumActivationDepth(int n) {
        this._config.put(MAXIMUM_ACTIVATION_DEPTH, n);
    }

    int maximumActivationDepth() {
        return this._config.getAsInt(MAXIMUM_ACTIVATION_DEPTH);
    }

    public void minimumActivationDepth(int n) {
        this._config.put(MINIMUM_ACTIVATION_DEPTH, n);
    }

    public int minimumActivationDepth() {
        return this._config.getAsInt(MINIMUM_ACTIVATION_DEPTH);
    }

    public TernaryBool callConstructor() {
        if (this._config.get(TRANSLATOR) != null) {
            return TernaryBool.YES;
        }
        return this._config.getAsTernaryBool(CALL_CONSTRUCTOR);
    }

    private Hashtable4 exceptionalFieldsOrNull() {
        return (Hashtable4)this._config.get(EXCEPTIONAL_FIELDS);
    }

    private Hashtable4 exceptionalFields() {
        Hashtable4 hashtable4 = this.exceptionalFieldsOrNull();
        if (hashtable4 == null) {
            hashtable4 = new Hashtable4(16);
            this._config.put(EXCEPTIONAL_FIELDS, hashtable4);
        }
        return hashtable4;
    }

    public ObjectField objectField(String string) {
        Hashtable4 hashtable4 = this.exceptionalFields();
        Config4Field config4Field = (Config4Field)hashtable4.get(string);
        if (config4Field == null) {
            config4Field = new Config4Field(this, string);
            hashtable4.put(string, (Object)config4Field);
        }
        return config4Field;
    }

    public void persistStaticFieldValues() {
        this._config.put(PERSIST_STATIC_FIELD_VALUES, true);
    }

    boolean queryEvaluation(String string) {
        Config4Field config4Field;
        Hashtable4 hashtable4 = this.exceptionalFieldsOrNull();
        if (hashtable4 != null && (config4Field = (Config4Field)hashtable4.get(string)) != null) {
            return config4Field.queryEvaluation();
        }
        return true;
    }

    public void readAs(Object object) {
        Config4Impl config4Impl = this.config();
        ReflectClass reflectClass = config4Impl.reflectorFor(object);
        if (reflectClass == null) {
            return;
        }
        this._config.put(WRITE_AS, this.getName());
        config4Impl.readAs().put(this.getName(), (Object)reflectClass.getName());
    }

    public void rename(String string) {
        this.config().rename(new Rename("", this.getName(), string));
        this.setName(string);
    }

    public void storeTransientFields(boolean bl) {
        this._config.put(STORE_TRANSIENT_FIELDS, bl);
    }

    public void translate(ObjectTranslator objectTranslator) {
        if (objectTranslator == null) {
            this._config.put(TRANSLATOR_NAME, null);
        }
        this._config.put(TRANSLATOR, objectTranslator);
    }

    void translateOnDemand(String string) {
        this._config.put(TRANSLATOR_NAME, string);
    }

    public void updateDepth(int n) {
        this._config.put(UPDATE_DEPTH, n);
    }

    Config4Impl config() {
        return this._configImpl;
    }

    boolean generateUUIDs() {
        return this._config.getAsBoolean(GENERATE_UUIDS);
    }

    boolean generateVersionNumbers() {
        return this._config.getAsBoolean(GENERATE_VERSION_NUMBERS);
    }

    void maintainMetaClass(boolean bl) {
        this._config.put(MAINTAIN_METACLASS, bl);
    }

    boolean staticFieldValuesArePersisted() {
        return this._config.getAsBoolean(PERSIST_STATIC_FIELD_VALUES);
    }

    public ObjectAttribute queryAttributeProvider() {
        return (ObjectAttribute)this._config.get(QUERY_ATTRIBUTE_PROVIDER);
    }

    boolean storeTransientFields() {
        return this._config.getAsBoolean(STORE_TRANSIENT_FIELDS);
    }

    int updateDepth() {
        return this._config.getAsInt(UPDATE_DEPTH);
    }

    String writeAs() {
        return this._config.getAsString(WRITE_AS);
    }
}

