/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  popup menu
*/

#include "common.h"

static GtkWidget *menu, *autoplay;

static void create_list(GtkWidget *parent, char **ids, GtkSignalFunc func);
static void cb_auto_browse(char *id);
static void cb_menu(GtkWidget *widget, guint action);
static void cb_popup(GtkWidget *widget, guint action);


void popup_init(void)
{
	GtkItemFactoryEntry menus[] =
	{
		{ _("/Sinek"), NULL, NULL, 0, "<Title>" },
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/Windows"), NULL, NULL, 0, "<Branch>" },
		{ _("/Windows/Toggle"), NULL, cb_menu, CMD_TOGGLE_GUI, NULL },
		{ _("/Windows/Control Panel"), NULL, cb_menu, CMD_SHOW_CONTROLS, NULL },
		{ _("/Windows/Video Output"), NULL, cb_menu, CMD_SHOW_VIDEO, NULL },
		{ _("/Windows/Playlist"), NULL, cb_menu, CMD_SHOW_PLAYLIST, NULL },
		{ _("/Control"), NULL, NULL, 0, "<Branch>" },
		{ _("/Control/Play"), NULL, cb_menu, CMD_PLAY, NULL },
		{ _("/Control/Pause"), NULL, cb_menu, CMD_PAUSE, NULL },
		{ _("/Control/Stop"), NULL, cb_menu, CMD_STOP, NULL },
		{ _("/Control/Next"), NULL, cb_menu, CMD_NEXT, NULL },
		{ _("/Control/Previous"), NULL, cb_menu, CMD_PREVIOUS, NULL },
		{ _("/Control/Repeat Current"), NULL, cb_menu, CMD_TOGGLE_REPEAT, "<CheckItem>" },
		{ _("/Control/Repeat List"), NULL, cb_popup, 3, "<CheckItem>" },
		{ _("/Autoplay"), NULL, NULL, 0, "<Branch>" },
		{ _("/Subtitle"), NULL, NULL, 0, "<Branch>" },
		{ _("/Subtitle/Open..."), NULL, cb_popup, 4, NULL },
		{ _("/Subtitle/Toggle"), NULL, cb_menu, CMD_TOGGLE_SUBTITLES, NULL },
		{ _("/Subtitle/Set Position"), NULL, cb_popup, 1, NULL },
		{ _("/Subtitle/Select Font..."), NULL, cb_popup, 0, NULL },
		{ _("/Subtitle/Set Frame Rate"), NULL, cb_popup, 42, NULL },
#ifdef USE_GUILE
		{ _("/Scripts"), NULL, NULL, 0, "<Branch>" },
		{ _("/Scripts/Execute..."), NULL, cb_popup, 666, NULL },
#endif
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/Video Properties"), NULL, cb_menu, CMD_SHOW_TUNER, NULL },
		{ _("/Key Bindings"), NULL, cb_menu, CMD_SHOW_KEYS, NULL },
		{ _("/Settings"), NULL, cb_menu, CMD_SHOW_PREFS, NULL },
		{ "/sep", NULL, NULL, 0, "<Separator>" },
		{ _("/About"), NULL, cb_menu, CMD_SHOW_ABOUT, NULL },
		{ _("/Quit"), NULL, cb_menu, CMD_QUIT, NULL },
	};
	GtkItemFactory *fabrika;
	gint n = sizeof(menus) / sizeof(menus[0]);
	char **ids;

	fabrika = gtk_item_factory_new(GTK_TYPE_MENU, "<main>", NULL);
	gtk_item_factory_create_items(fabrika, n, menus, NULL);
	menu = gtk_item_factory_get_widget(fabrika, "<main>");

	autoplay = gtk_item_factory_get_widget(fabrika, _("/Autoplay"));
	ids = xine_get_autoplay_input_plugin_ids(sinek.xine);
	create_list(autoplay, ids, GTK_SIGNAL_FUNC(cb_auto_browse));

	sinek.repeat_chk = gtk_item_factory_get_widget(fabrika, _("/Control/Repeat Current"));
	if(sinek.repeat_one)
	{
		GTK_CHECK_MENU_ITEM(sinek.repeat_chk)->active = TRUE;
		gtk_widget_queue_draw(sinek.repeat_chk);
	}
}


void popup_pop(int time)
{
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, time);
	gtk_widget_grab_focus(GTK_WIDGET(menu));
	gtk_widget_activate(GTK_WIDGET(menu));
}


static void cb_auto_browse(char *id)
{
	GtkWidget *popup;
	int num;
	char **mrls;

	mrls = xine_get_autoplay_mrls(sinek.xine, id, &num);
	if(!mrls) return;
	if(num == 1)
	{
		video_play(*mrls);
		return;
	}
	popup = gtk_menu_new();
	create_list(popup, mrls, GTK_SIGNAL_FUNC(video_play));
	gtk_menu_popup(GTK_MENU(popup), NULL, NULL, NULL, NULL, 3, 0);
	gtk_widget_grab_focus(GTK_WIDGET(popup));
	gtk_widget_activate(GTK_WIDGET(popup));
}


static void cb_menu(GtkWidget *widget, guint action)
{
	execute_cmd((cmd_type)action);
}


static void cb_popup(GtkWidget *widget, guint action)
{
	switch(action)
	{
		case 0:
			osd_font_selection();
			break;
		case 1:
			sinek.osd_place = 1;
			break;
		case 3:
			sinek.repeat_all = ~sinek.repeat_all;
			break;
		case 4:
			select_file(osd_load, _("Select subtitle file..."));
			break;
		case 42:
			subtitle_create();
			break;
#ifdef USE_GUILE
		case 666:
			select_file(guile_execute, _("Select a Scheme script..."));
			break;
#endif
	}
}


static void create_list(GtkWidget *parent, char **ids, GtkSignalFunc func)
{
	GtkWidget *item;
	char *id;

	id = *ids++;
	while(id)
	{
		item = gtk_menu_item_new_with_label(id);
		gtk_widget_show(item);
		gtk_menu_append(GTK_MENU(parent), item);
		gtk_signal_connect_object(GTK_OBJECT(item), "activate", func, (gpointer)id);
		id = *ids++;
	}
}
