/* -*- c++ -*-
 * __BEGIN_COPYRIGHT
 * SimpleDB API
 * 
 * Copyright (C) 2005 Eminence Technology Pty Ltd
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can view the GNU Lesser General Public Licence at
 * http://www.gnu.org/licenses/lgpl.html or you can write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Eminence Technology Pty Ltd can be contacted by writing to
 * Eminence Technology, PO Box 118, Moorooka QLD 4105, Australia.
 * Alternatively, you may email opensource [at] eminence [dot] com [dot] au
 * __END_COPYRIGHT
 */

#ifndef __SIMPLEDB_FACTORY_H_
#define __SIMPLEDB_FACTORY_H_ 

#include "Database.h"
#include <memory>

namespace SimpleDB {

  /** This simple singleton factory produces and creates memory for database handles
   * to be returned to the client.
   *
   * Currently this factory is not useful. It will be used in future for
   * connection pooling. Work needs to be done to make it thread safe
   * and exception safe.
   *
   * \throw SimpleDB Exceptions (same as those thrown during normal creation)
   * \todo add mutual exclusion with algorithm for intelligent handing out of 
   * connection handles (block based on some algorithm to improve efficiency)
   */
  class SimpleDBFactory {
  public:
    /** Return the single instance of the SimpleDB Factory
     */
    static SimpleDBFactory* Instance() ;
    
    /** Create an auto_ptr and return it, then ownership has to be transferred to the caller
     * @param dsn The Database source name
     * @return auto_ptr to Database.
     */ 
    static std::auto_ptr<Database> getDBHandle(const std::string dsn);
    
    /** Destroy the factory for normal cleanup.
     */
    static void Kill () ;
  protected:

    /** Hidden constructor.
     */
    SimpleDBFactory() {};

    /** From persistent singleton pattern. Make sure only one
     * instance of the factory will be created.
     */
    static SimpleDBFactory* _instance ;
  };
};
#endif
