/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* vim:expandtab:shiftwidth=4:tabstop=4:
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Christopher Blizzard
 * <blizzard@mozilla.org>.  Portions created by the Initial Developer
 * are Copyright (C) 2002 the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Pierre Phaneuf <pp@ludusdesign.com> 
 *   Roland Mainz <roland.mainz@informatik.med.uni-giessen.de>
 *   Brian Stell <bstell@ix.netcom.com>
 *   Morten Nilsen <morten@nilsen.com>
 *   Jungshik Shin <jshin@mailaps.org>
 *   Jim Nance <jim_nance@yahoo.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 
// Extracted from the mozilla code nsFontMetricsXft.cpp

#include "prtypes.h"
#include "nsAutoDrawSpecBuffer.h"

void
nsAutoDrawSpecBuffer::Draw(nscoord x, nscoord y, XftFont *font, FT_UInt glyph)
{
    if (mSpecPos >= BUFFER_LEN-1)
        Flush();

    mSpecBuffer[mSpecPos].x = x;
    mSpecBuffer[mSpecPos].y = y;
    mSpecBuffer[mSpecPos].font = font;
    mSpecBuffer[mSpecPos].glyph = glyph;
    //printf("%d %d (%d)\n", x, y, glyph);
    ++mSpecPos;
}



void
nsAutoDrawSpecBuffer::Flush()
{
    if (mSpecPos) {
        // Some Xft libraries will crash if none of the glyphs have any
        // area.  So before we draw, we scan through the glyphs.  If we
        // find any that have area, we can draw.
        for (PRUint32 i = 0; i < mSpecPos; i++) {
            XftGlyphFontSpec *sp = &mSpecBuffer[i];
            XGlyphInfo info;
            XftGlyphExtents(mDisplay, sp->font, &sp->glyph, 1, &info);
            if (info.width && info.height) {
                // If we get here it means we found a drawable glyph.  We will
                // Draw all the remaining glyphs and then break out of the loop
                XftDrawGlyphFontSpec(mDraw, mColor, mSpecBuffer+i, mSpecPos-i);
                break;
            }
        }
        mSpecPos = 0;
    }
}
