//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

#ifndef SIGC_PERL_SLOT_H
#define SIGC_PERL_SLOT_H

#include <assert.h>
#include <exception>
#include <sigc++/slot.h>

extern "C" {
#include "EXTERN.h"
#include "perl.h"
}
#undef ref

#include <sigcperl/data.h>

namespace SigCPerl {

// Similar to (flags & G_VOID), but works if G_VOID == 0
bool VoidContext(I32 flags);

class Slot
{
 public:
  // InternalType needs to take Data as the last arg instead of const Data&
  // so that the internal slot produced with SigC::bind() can hold the
  // reference to the callback data.
  typedef SigC::Slot3<Data,const Data&,I32,Data> InternalType;
  typedef SigC::Slot2<Data,const Data&,I32> SlotType;
  typedef SlotType::Proxy Proxy;

  class BadParams : public std::exception {};

  // construct from args passed from perl
  Slot(const Data &data) throw(BadParams);
  // used by SignalWrapper::slot()
  Slot(const InternalType &slot, const Data &data) throw()
	: m_slot(slot), m_data(data) {}

  Slot& bind(const Data &data) throw();
  Data call(const Data &data, I32 flags) throw();
  SlotType slot() const throw();
  // FIXME add convert()

 private:
  InternalType m_slot;
  Data m_data;
};

Slot ParseToSlot(const Data &data) throw(Slot::BadParams);

} // namespace SigCPerl

#endif // SIGC_PERL_SLOT_H
