/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    filesys.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlefilesys() Function
//	determine the correct procedure to use
void handlefilesys () {
	//  proc/filesys in all kernels are compatible
	handlefilesysv20 ();
}

// handlefilesysv20() Function
void handlefilesysv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int c=0;

	sprintf (filename, "%sfilesystems", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgetstr (filep, tmpstring, INPUT_STRING);
		if (strlen(tmpstring)==0) break;
		FILESYS[c]=malloc(FILESYS_STRUCT_SIZE);
		if (FILESYS[c]==NULL) error_handler(ERROR_MALLOC);
		FILESYS[c]->NAME[0]=0;
		FILESYS[c]->DEV[0]=0;
		if (cinstr(tmpstring, 9)==0)
			strncpy (FILESYS[c]->NAME, tmpstring+1, STORAGE_STRING);
		else
			sscanf (tmpstring, "%s\t%s", FILESYS[c]->DEV, FILESYS[c]->NAME);
		c++;
		if (c==FILESYS_COUNT_MAX) break;
	} while (0==0);
	NUM_FILESYS=c-1;
	fclose (filep);
	return;
}

