/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* zipfile.cpp*/

#include "zipfile.h"

#include <stdlib.h>


ZipFile::ZipFile (const char *archive, const char *file)
  {
    this->archive = new QString (archive);
    this->file = new QString (file);

    stdout = new QCString ();
  };
  
ZipFile::~ZipFile()
{
}

int
ZipFile::size ()
{

  QString
    com;
  com.
    sprintf
    (" unzip -Z  \"%s\" \"%s\" | tr -s \" \" \" \" | cut -d\" \" -f 4",
     (const char *) *archive, (const char *) *file);

  KShellProcess *
    proc = new KShellProcess ();
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (slotMsgRcv (KProcess *, char *, int)));

  *proc << com;
  proc->start (KShellProcess::Block, KShellProcess::Stdout);

  return stdout->toInt ();
};


bool
ZipFile::deleteFile ()
{
  QString
    com;
  com.sprintf (" zip -d  \"%s\" \"%s\"", (const char *) *archive,
	       (const char *) *file);
  KShellProcess *
    proc = new KShellProcess ();
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (slotMsgRcv (KProcess *, char *, int)));

  *proc << com;
  proc->start (KShellProcess::Block);	

  return true;

}

void
ZipFile::slotMsgRcv (KProcess * proc, char *buffer, int buflen)
{
  stdout = new QCString (buffer, buflen);
}
