/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* mainwindow.h */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include "showimg.h"
#include "extract.h"
#include "imagelisteview.h"
#include "directoryview.h"
#include "directory.h"
#include "displayCompare.h"
#include "history_action.h"

#include <qmessagebox.h>
#include <qprogressbar.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qarray.h>
#include <qdict.h>
#include <qkeycode.h>
#include <qdir.h>
#include <qtimer.h>
#include <qmenubar.h>
#include <qvector.h>
#include <qprogressdialog.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kwin.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kdocktabctl.h>
#include <kdockwidget.h>
#include <kapp.h>

#include <kbookmarkmanager.h>
#include <kbookmarkmenu.h>
#include <kbookmarkbar.h>
#include <kbookmark.h>

#include <kaccel.h>
#include <kaction.h>


class Directory;
class DirectoryView;


/**
	a class to store datas to look for similaties of 2 images
*/
class ImageSimilarityData
{
public:
    ImageSimilarityData();
    ~ImageSimilarityData();
        
        uint *avg_r;
        uint *avg_g;
        uint *avg_b;

        int filled;
};


class MainWindow:public KDockMainWindow, public KBookmarkOwner
{
	Q_OBJECT
public:
	MainWindow (const char *name="MainWindow");
	MainWindow (const char *pic, const char *name);

	~MainWindow();

	void keyPressEvent (QKeyEvent *);

	/**
		@return true if the 2 files are the sames
	*/
	bool equals(QFile*, QFile*);

	/**
		launch the exact comparison
	*/	
	void compareFast();
	
	/**
		launch the approximative comparison
	*/
	void compareAlmost();

	DirectoryView* getDirectoryView();
	Directory* findDir(const char *);
	void nextDir (Directory * r);

	/**
		open a directory given its fullname
	*/
	bool open (const char *);

	/**
		diplay the txt in the status bar
	*/
	void setMessage (const char *txt);
	
	/**
		set the number of item in the file view in the statusbar
	*/
	void setNbrItems (int nbr);
	
	/**
		set the zoom of displayed image in the statusbar
	*/	
	void setZoom (int zoom);
	
	/**
		set the Imagename of displayed image in the statusbar
	*/	
	void setImagename (const char *name);
	
	/**
		set the Imagetype of displayed image in the statusbar
	*/	
	void setImagetype (const char *type);
	
	/**
		set the Dimension of displayed image in the statusbar
	*/	
	void setDim (QSize *size);
	
	/**
		set the Size  of displayed image in the statusbar
	*/	
	void setSize (int size);
	
	/**
		set the Date  of displayed image in the statusbar
	*/	
	void setDate (QDate *date);
	
	/**
	*/
	void setActionsEnabled(bool enable);  
	
	/**
		set the imageViewer to an empty image
	*/
	void setEmptyImage();

	/**
		@return true if icons preview is enabled
	*/
	bool preview();	
	void setOnTop(bool onTop);

	/**
	 * This function is called if the user selects a bookmark.  It will
	 * open up the bookmark in a default fashion unless you override it.
	 */
	virtual void openBookmarkURL(const QString& _url);

	/**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The title will become the
	 * "name" of the bookmark.  You must overload this function if you
	 * wish to give your users the ability to add bookmarks.
	 *
	 * @return the title of the current page.
	 */
	virtual QString currentTitle() const;

	 /**
	 * This function is called whenever the user wants to add the
	 * current page to the bookmarks list.  The URL will become the URL
	 * of the bookmark.  You must overload this function if you wish to
	 * give your users the ability to add bookmarks.
	 *
	 * @return the URL of the current page.
	 */
	virtual QString currentURL() const;

	
	/**
		@return true if in fullscreen mode
	*/
	bool fullScreen();
	
	/**
		copy uris to the specified directory
	*/
	void copyFilesTo(QStrList uris, QString dest);
	
	/**
		move uris to the specified directory
	*/
	void moveFilesTo(QStrList uris, QString dest);

	void startWatchDir();
	void stopWatchDir();
	
	
	QProgressBar *progress;
	int total;
	int done;	  
	ImageViewer *iv;


public slots:
	void setHasImageSelected(bool selected);

	void slotFullScreen (); //switch to full screen and windows mode
	void slotSlideShow ();  //launch the slide show
	void slotPreview ();	  //show/hide thes thumbertails
	void slotRefresh ();	 //refresh the image list
	void slotRefresh (const char *dir);	//refresh a specifique dir
	void slotKeepFit();	   // fit/unfit to screen
	void slotEnlarge ();
	void slotShrink ();
	void slotSmooth ();    //smooth/unsmooth
	void slotCompareFast (){compareFast();}; //compare the pictures loaded
	void slotCompareAlmost (){compareAlmost();}; //compare the pictures loaded

	void myDialogSlot();  
	void convert();  

	void slotNewWindow();
	void slotPrint();
	void slotQuickPrint();
	void slotOpenLocation();
	void slotUndo();
	void slotRedo();
	void slotMovetotrash();
	void slotShred();    


	void slotTODO ();
	void slotcopy ();
	void slotcopyPixmap ();
	void slotcut ();
	void slotpaste ();
	void slotRotateLeft();
	void slotRotateRight();
	void slotStop();
	void slotZoomIn();
	void slotZoomOut() ;
	void slotZoom();
	void slotZoomNo();
	void slotZoomLock();
	void configureKey();
	void configureToolbars();
	void configureShowImg();
	void slotBookmark();

	void slotForward();
	void slotBack();


	void slotAddImage (int number=1);
	void slotRemoveImage();
	void slotPreviewDone ();
	void slotReset (bool init=true);
	void slotDone ();
	void slotRemoveImage (int val);
	void slotMirrorH ();
	void slotMirrorV ();
	void slotDirChange (const QString & dir);
	void slotFileChange (const QString & file);
	void slotPreferences();
	void slotEditFileType();
	void renameSeries();

	void slotArrangement();
	void slotTxtPos();
	
	void slotIconSize();

	void setMessage(QString msg);  

	void changeDirectory(QString);
	void backMenuActivated(int);
	void forwardMenuActivated(int);
	void slotForwardAboutToShow();
	void slotBackAboutToShow();

	void quit();
	bool close();

	void slotDirCut();
	void slotDirCopy();
	void slotDirMove();
	void slotDirPaste();

	void toolsRotateLeft();
	void toolsRotateRight();

private slots:
	void slotEndConvert(KProcess *);
	
	
protected:
	bool inFullScreen;
	void init ();

	void closeEvent( QCloseEvent* );

	QString getFileName(QString *fullName);
	QString getFileExt(QString *fullName);
	QString getFullName(QString *fullName);
	QString getFullPath(QString *fullName);  

	int getRed(QImage *im, int x, int y);
	int getGreen(QImage *im, int x, int y);
	int getBlue(QImage *im, int x, int y);

	ImageSimilarityData* image_sim_fill_data(QImage *pixbuf);
	float image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b);
	float image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, float min);

	void updateHistory();
	void go( int steps );

	QLabel *label;

	QPopupMenu *file;
	QPopupMenu *options;

	KDockWidget *dockIV;
	KDockWidget *dockDir;
	KDockWidget *dockIL;

	Directory *root;

	ImageListeView *imageList;
	DirectoryView *dirView;

	QSize oldSize;
	QPoint oldPos;

	QTimer *timer;

	KToolBar *mainToolbar, *pathToolbar;


private:
	
	QColor bgColor;
	bool checkDelete, checkShred, checkTrash;
	int grayscale, slideshowTime, slideshowType;
	bool storeth;
	bool smooth;

	bool hasimageselected;
	QString currentDir;
	QLabel *lnbrItems, *lZoom, *lImagename, *lImagetype, *lDim, *lSize, *lDate;

	int fit; //index of 'fit' to screen menu
	int ss;  //index of 'smooth' menu
	bool inInterface;

	void createActions();  
	void createAccels();
	void createMenus();
	void createToolbar();
	void createStatusbar();
	void createMainView();
	void initSize();
	void setLayout(int layout);

	KActionCollection *actionCollect;

	KAction *aCut, *aCopy, *aPaste, *aDelete, *aCopyPixmap,
	      *aNewWindow,
	      *aPrint, *aQuickPrint,
	      *aOpenLocation,
	      *aQuit,*aClose,
	      *aUndo,*aRedo,
	      *aRename,*aTrash,*aShred,
	      *aEditType,*aFileProperties,*aImageProperties,
	      *aImageInfo, *aDirInfo,
	      *aSelect,*aUnselect,*aUnselectAll,*aInvertSelection,
	      *aPrevious,*aNext,*aFirst,*aLast,
	      *aConfigureKey,*aConfigureToolbars,*aConfigureShowImg,
	      *aRenameSeries,
	      *aCompareFast,*aCompareAlmost,*aCovert,
	      *aRotLeft,*aRotRight,*aHMirror,*aVMirror,
	      *aReloadDir,*aStop,
	      *aFullScreen,*aZoomIn,*aZoomOut,*aZoomNo,*aZoomFit, *aZoomFitWidth, *aZoomFitHeight,
	      *aOpenWithGimp,*aOpenWith,
	      *aWallpaper_CENTER,*aWallpaper_MOSAIC,*aWallpaper_CENTER_MOSAIC,*aWallpaper_CENTER_MAX,*aWallpaper_ADAPT,*aWallpaper_LOGO,

	      *aDirNewFolder, *aDirProperties,
	      *aDirCut, *aDirCopy, *aDirPaste, *aDirMove, *aDirPasteFiles,
	      *aDirRename, *aDirTrash, *aDirDelete,
	      *aDirBookmark,
	      *aFilesMoveTo, *aFilesCopyTo,
	
	      *aScrollXR, *aScrollXL, *aScrollYB, *aScrollYT,
	      
	      *aToolsRotateLeft, *aToolsRotateRight;


	HistoryAction *aBack, *aForward;
	HistoryEntryList m_lstHistory;

	KToggleAction *aSlideshow,
	      *aSmooth,
	      *aPreview,
	      *aEnlarge, *aShrink,
	      *aZoomLock;

	KRadioAction
	      *aIconSmall, *aIconMed, *aIconBig,
	      *aArrangementLR, *aArrangementTB,
	      *aArrangementB, *aArrangementR,
	      *aSortBySize,*aSortByType,*aSortByName, *aSortByDate;

	KAccel* mAccel;
	KActionMenu* abookmarkmenu;

	KBookmarkMenu *mBookMenu;

};
#endif
