/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "kexifpropsplugin.h"
#include "exif.h"

#include <qlistview.h> 
#include <qheader.h>
#include <qlayout.h>
#include <qclipboard.h> 
#include <qapplication.h> 
#include <qdragobject.h> 

#include <klocale.h>

KEXIFPropsPlugin::KEXIFPropsPlugin( KPropertiesDialog *_props, QString fileName )
:KPropsDlgPlugin(_props)
{
	KDialogBase *dialog=_props->dialog();
	QFrame *page=dialog->addPage( i18n("&Metadata"));
	QString info=ProcessFile(fileName);
	this->info=info;
	
	QBoxLayout *lyMain=new QVBoxLayout(page);	
	QListView *listView = new QListView(page);
	lyMain->addWidget(listView);
	
	listView->addColumn(i18n("Title"));
        listView->header()->setClickEnabled( FALSE, listView->header()->count() - 1 );
	listView->addColumn(i18n("Data"));
        listView->header()->setClickEnabled( FALSE, listView->header()->count() - 1 );
	listView->setAllColumnsShowFocus ( true ); 
	
	QPushButton *butCopy=new QPushButton(i18n("Copy"), page);
	lyMain->addWidget(butCopy);
	connect(butCopy, SIGNAL(clicked()), this, SLOT(copy()));
	
	int pos = info.find ("\n");
	int i=0;
	
	while (pos != -1)
	{
		QString line = info.left(pos);
		int dp=line.find (":");
		QString debut=line.left(dp).stripWhiteSpace();
		QString fin=line.mid(dp+1, line.length()).stripWhiteSpace();
		QString order;
		order.sprintf ("%10d",i);
		if(dp!=-1)
			(void)new QListViewItem(listView, debut, fin, order);
	  
		info = info.right (info.length () - pos - 1);
		pos = info.find ("\n");
	}
	listView->setSorting(2, false);
	listView->sort();
}


void KEXIFPropsPlugin::applyChanges()
{
}

void KEXIFPropsPlugin::copy()
{
	QApplication::clipboard()->setText(info); 
}

