/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JPGOPTIONS_H
#define JPGOPTIONS_H

#include <qvariant.h>
#include <qdialog.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QComboBox;
class QFrame;
class QGroupBox;
class QLabel;
class QPushButton;
class QSlider;
class QSpinBox;

class JPGOptions : public QDialog
{ 
	Q_OBJECT

public:
	JPGOptions( QWidget* parent = 0, const char* name = 0, bool modal = TRUE, WFlags fl = 0 );
	~JPGOptions();

	QString getOptions();
        
private:
	QFrame* Line1;
	QLabel* TextLabel6;
	QPushButton* PushButton20;
	QPushButton* PushButton21;
	QPushButton* PushButton22;
	QGroupBox* GroupBox13;
	QLabel* TextLabel4;
	QLabel* TextLabel5;
	QSpinBox* SpinBox1;
	QSlider* qualitySslider1;
	QComboBox* samplingComboBox;
	QCheckBox* progressiveCheckBox;
	QCheckBox* optimiseCheckBox;
	QSpinBox* smootingSpinBox;
	QLabel* TextLabel7;
	QCheckBox* saveCheckBox;
	QHBoxLayout* Layout1;
	QHBoxLayout* Layout2;

public slots:
	virtual void reset();

};

#endif // JPGOPTIONS_H
