/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "jpgoptions.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kapp.h>
#include <klocale.h>

/* 
 *  Constructs a JPGOptions which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
JPGOptions::JPGOptions( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "JPGOptions" );
    resize( 400, 271 );
    setMinimumSize( QSize( 400, 270 ) );
    setCaption( i18n( "JPG options" ) );

    saveCheckBox = new QCheckBox( this, "saveCheckBox" );
    saveCheckBox->setGeometry( QRect( 10, 200, 360, 16 ) );
    saveCheckBox->setText( i18n( "&Save the settings as the default" ) );
    QWhatsThis::add(  saveCheckBox, i18n( "Save these parameters\n"
"for the next times" ) );

    GroupBox13 = new QGroupBox( this, "GroupBox13" );
    GroupBox13->setGeometry( QRect( 10, 0, 371, 100 ) );
    GroupBox13->setTitle( i18n( "Image quality" ) );

    SpinBox1 = new QSpinBox( GroupBox13, "SpinBox1" );
    SpinBox1->setGeometry( QRect( 160, 60, 51, 21 ) );
    SpinBox1->setButtonSymbols( QSpinBox::UpDownArrows );
    SpinBox1->setMaxValue( 100 );
    SpinBox1->setValue( 75 );

    QWidget* privateLayoutWidget = new QWidget( GroupBox13, "Layout1" );
    privateLayoutWidget->setGeometry( QRect( 10, 20, 350, 32 ) );
    Layout1 = new QHBoxLayout( privateLayoutWidget );
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );

    TextLabel4 = new QLabel( privateLayoutWidget, "TextLabel4" );
    TextLabel4->setText( i18n( "Best\n"
"compression" ) );
    TextLabel4->setAlignment( int( QLabel::AlignCenter ) );
    Layout1->addWidget( TextLabel4 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    qualitySslider1 = new QSlider( privateLayoutWidget, "qualitySslider1" );
    qualitySslider1->setMinimumSize( QSize( 180, 0 ) );
    qualitySslider1->setMaximumSize( QSize( 200, 32767 ) );
    qualitySslider1->setMaxValue( 100 );
    qualitySslider1->setValue( 75 );
    qualitySslider1->setOrientation( QSlider::Horizontal );
    qualitySslider1->setTickmarks( QSlider::Left );
    qualitySslider1->setTickInterval( 0 );
    QWhatsThis::add(  qualitySslider1, i18n( "Choose the quality\n"
"of the converted picture" ) );
    Layout1->addWidget( qualitySslider1 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer_2 );

    TextLabel5 = new QLabel( privateLayoutWidget, "TextLabel5" );
    TextLabel5->setText( i18n( "Best\n"
"quality" ) );
    TextLabel5->setAlignment( int( QLabel::AlignCenter ) );
    Layout1->addWidget( TextLabel5 );

    QWidget* privateLayoutWidget_2 = new QWidget( this, "Layout2" );
    privateLayoutWidget_2->setGeometry( QRect( 10, 110, 370, 32 ) );
    Layout2 = new QHBoxLayout( privateLayoutWidget_2 );
    Layout2->setSpacing( 6 );
    Layout2->setMargin( 0 );

    progressiveCheckBox = new QCheckBox( privateLayoutWidget_2, "progressiveCheckBox" );
    progressiveCheckBox->setText( i18n( "&Progressive" ) );
    QWhatsThis::add(  progressiveCheckBox, i18n( "Hava to use the\n"
"progressive algorithm ?" ) );
    Layout2->addWidget( progressiveCheckBox );

    TextLabel6 = new QLabel( privateLayoutWidget_2, "TextLabel6" );
    TextLabel6->setText( i18n( "Component\n"
"sampling" ) );
    TextLabel6->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Layout2->addWidget( TextLabel6 );

    samplingComboBox = new QComboBox( FALSE, privateLayoutWidget_2, "samplingComboBox" );
    samplingComboBox->insertItem( i18n( "YUV 122 (default)" ) );
    samplingComboBox->insertItem(i18n( "GRAY (to gray scale)" ) );
    samplingComboBox->insertItem(i18n( "CMYK" ) );
    Layout2->addWidget( samplingComboBox );

    TextLabel7 = new QLabel( this, "TextLabel7" );
    TextLabel7->setGeometry( QRect( 20, 151, 230, 20 ) );
    TextLabel7->setText( i18n( "Smoothing" ) );
    TextLabel7->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    QWhatsThis::add(  TextLabel7, i18n( "Choose how to\n"
"smooth the image" ) );

    smootingSpinBox = new QSpinBox( this, "smootingSpinBox" );
    smootingSpinBox->setGeometry( QRect( 260, 150, 40, 21 ) );

    Line1 = new QFrame( this, "Line1" );
    Line1->setGeometry( QRect( 10, 180, 361, 16 ) );
    Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    PushButton22 = new QPushButton( this, "PushButton22" );
    PushButton22->setGeometry( QRect( 300, 230, 80, 30 ) );
    PushButton22->setText( i18n( "&Reset All" ) );

    PushButton21 = new QPushButton( this, "PushButton21" );
    PushButton21->setGeometry( QRect( 210, 230, 81, 30 ) );
    PushButton21->setText( i18n( "&Cancel" ) );

    PushButton20 = new QPushButton( this, "PushButton20" );
    PushButton20->setGeometry( QRect( 120, 230, 81, 30 ) );
    PushButton20->setText( i18n( "&OK" ) );

    // signals and slots connections
    connect( qualitySslider1, SIGNAL( sliderMoved(int) ), SpinBox1, SLOT( setValue(int) ) );
    connect( SpinBox1, SIGNAL( valueChanged(int) ), qualitySslider1, SLOT( setValue(int) ) );
    connect( PushButton20, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( PushButton21, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( PushButton22, SIGNAL( clicked() ), this, SLOT( reset() ) );

    // tab order
    setTabOrder( qualitySslider1, SpinBox1 );
    setTabOrder( SpinBox1, progressiveCheckBox );
    setTabOrder( progressiveCheckBox, samplingComboBox );
    setTabOrder( samplingComboBox, smootingSpinBox );
    setTabOrder( smootingSpinBox, saveCheckBox );
    setTabOrder( saveCheckBox, PushButton20 );
    setTabOrder( PushButton20, PushButton21 );
    setTabOrder( PushButton21, PushButton22 );


}

/*  
 *  Destroys the object and frees any allocated resources
 */
JPGOptions::~JPGOptions()
{
    // no need to delete child widgets, Qt does it all for us
}

void JPGOptions::reset()
{
    SpinBox1->setValue( 75 );

    smootingSpinBox->setValue(0);
    samplingComboBox->setCurrentItem (0);
}

QString JPGOptions::getOptions()
{
    QString opt;
    opt = QString("-quality ") + QString().setNum(SpinBox1->value());
    if (progressiveCheckBox->isChecked ())
        opt+=" -interlace Plane";
    if(smootingSpinBox->value()!=1)
        opt+=" -blur "+ QString().setNum(smootingSpinBox->value()); 
    if(samplingComboBox->currentItem()==0)
        opt+=" -colorspace YUV";
    else
    if(samplingComboBox->currentItem()==1)
        opt+=" -colorspace GRAY";
    else
    if(samplingComboBox->currentItem()==2)
        opt+=" -colorspace CMYK";
   return opt+" ";
}

