/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __IMAGELOADER_H__
#define __IMAGELOADER_H__

#include <qevent.h>
#include <qwidget.h>
#include <qlist.h>
#include <qimage.h>
#include <qfileinfo.h>

#include <kurl.h>
#include <pthread.h>

#define	Event_ImageLoad		QEvent::Enter
class ImageLoadEvent:public QEvent
{
public:
	ImageLoadEvent (QFileInfo * fi, QWidget * w, bool t =
	        	true):QEvent (Event_ImageLoad), Info (fi), Widget (w),
	  Threaded (t){}
	QFileInfo *fileInfo () const
	{
		return Info;
	}
	QWidget *widget () const
	{
		return Widget;
	}
	bool threaded () const
	{
		return Threaded;
	}
private:
	QFileInfo * Info;
	QWidget *Widget;
	bool Threaded;
};

#define	Event_NextImage		QEvent::Close
class NextImageEvent:public QEvent
{
public:
	NextImageEvent ():QEvent (Event_NextImage)
	{
	}
};

class ImageLoader:public QObject
{
	friend void *__thread_start (void *);
	friend void __thread_cleanup (void *);

public:
	ImageLoader (QWidget * parent = 0, const char *name = 0);
	~ImageLoader ();

	void loadMiniImage (QFileInfo * fi, QWidget * w, bool threaded = true);
	void stopLoading (bool clean = true);

	void setThumbnailSize(QSize newSize);
	QSize getThumbnailSize();
  
  
protected:
	QSize size;

	void startLoading ();
	void loadImageInternal (ImageLoadEvent * e);
	void cantLoad (ImageLoadEvent * e);
	bool initLoading (ImageLoadEvent * e);
	void finishLoading (ImageLoadEvent * e);
	void loadWithNoThread (QFileInfo * fi, QWidget * w);
	void nextImage ();

	virtual bool eventFilter (QObject * o, QEvent * e);
	virtual void timerEvent (QTimerEvent * e);

	void thread_start ();
	void thread_cleanup ();

private:
	QList < ImageLoadEvent > EventList;
	QList < ImageLoadEvent > ImageLoadedList;
	pthread_t ThreadID;
	pthread_mutex_t Mutex;
	bool Running;
	QPixmap info;
	
	bool mini_image_outdated, mini_image_file_exists, xvpics_dir_exists;
	QString mini_image_path, xvpics_path, image_path;
	QPixmap mini_image;
	KURL image_url;
	bool Loading;
	QImage InternalImage;
	QString InternalPath;
	ImageLoadEvent *InternalEvent;
};

#endif
