/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* imagefile.h */


#ifndef IMAGEFILE_H
#define IMAGEFILE_H

#include "fileitem.h"

#include "imageloader.h"
#include "directory.h"
#include "showimg.h"
#include "imagelisteview.h"

#include <qdragobject.h>
#include <qdropsite.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qpopupmenu.h>


class Directory;
class ImageViewer;

class ImageFileItem:public FileItem
{
public:
	ImageFileItem (ImageListeView * parent, Directory * parentDir,
	               const char *filename, const char *path,
	               ImageViewer * iv);
	virtual ~ImageFileItem();

	virtual void setName(QString n);
	virtual QString name();
	virtual QString fullName ();

	virtual void setText(const QString & text ); 
	virtual QString text(int column) const;
	virtual QString text() const;

	void setSelected (bool s);

	virtual bool suppression();
	virtual bool suppression(bool suprFile);
	virtual bool moveToTrash();
	virtual bool shred();
	
	int nbrImg;
	bool doPreload;

protected:
	virtual int width() const;
	QString shrink(QString str, int len=20) const;

private:
	ImageListeView *imageList;

	QFile f;
	QListView *p;
	bool readable;
	bool selected;

	QCString full;
	ImageViewer *iv;

	QPixmap *p_open;
	QPixmap *p_none;

	bool pixLoad;
	Directory *parentDir;
};


#endif
