/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DISPLAYCOMPARE_H__
#define __DISPLAYCOMPARE_H__


#include <qsplitter.h>
#include <qvector.h>
#include <qdict.h>
#include <qfile.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <kapp.h>
#include <klocale.h>
#include <kdialog.h>
        
class  DisplayCompare : public KDialog
{
 Q_OBJECT
public:
   DisplayCompare(QWidget* parent, QDict < QVector < QFile > >* cmp);
   ~DisplayCompare();
   
public slots :
  void slotDisplayRight(QListViewItem *);
  void slotDisplayLeft(QListViewItem *);
  void accept();
  void reject();
  void suppression();

private:
   QDict < QVector < QFile > >* cmp;

   QGroupBox* GroupBox2_2;
    QLabel* preview2;
    QGroupBox* GroupBox2;
    QLabel* preview1;
    QGroupBox* GroupBox8;
    QListView* listName;
    QListView* listEq;
    QPushButton* delettePushButton;
    QPushButton* closePushButton;
    void resizeEvent( QResizeEvent*);
};

#endif

