/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*directoryview.h*/


#ifndef __DIRECTORYVIEW_H__
#define __DIRECTORYVIEW_H__

#include "showimg.h"
#include "imagefileitem.h"
#include "compressedfile.h"
#include "imagelisteview.h" 

#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qtimer.h>
#include <qprogressdialog.h> 
#include <qdropsite.h>
#include <qdragobject.h>

#include <kiconloader.h>
#include <klistview.h>
#include <kdirwatch.h>
#include <kapp.h>

class ImageViewer;

class DirectoryView:public KListView
{
	Q_OBJECT

public:
	DirectoryView (QWidget * parent, ImageViewer * iv, ImageListeView * imageList, MainWindow * mw);

	
	/**
		the drag'n'drop events
	*/
	void contentsDragEnterEvent (QDragEnterEvent * event);
	void contentsDropEvent (QDropEvent * event);
	void contentsDragMoveEvent (QDragMoveEvent * e);
	void contentsDragLeaveEvent (QDragLeaveEvent *);
	
	/**
		the mouse event
	*/	
	void contentsMousePressEvent (QMouseEvent * e);
	
	/**
		init the menus
	*/
	void initMenu(KActionCollection *actionCollection);

	/**
		copy a list of local (ie file:/) urls into  the dest directory
	*/
	void copy(QStrList uris, QString dest);
	/**
		move a list of local (ie file:/) urls into  the dest directory
	*/
	void move(QStrList uris, QString dest);

	/**	
		@return true if the user is drropping files
	*/
	bool isDropping();

	/**
		return true if it have to show the warning message when move to trash files
	*/
	bool checkTrash();
	void setCheckTrash(bool trash);
	
	/**
		return true if it have to show the warning message when delete files
	*/
	bool checkDelete();
	void setCheckDelete(bool del);
	
	/**
		return true if it have to show the warning message when shred files
	*/
	bool checkShred();
	void setCheckShred(bool shred);

	/**
		return true if it have to show the hidden directories
	*/
	void setShowHiddenDir(bool show);
	bool showHiddenDir();
	
	/**
		return true if it have to show the hidden files
	*/
	void setShowHiddenFile(bool show);
	bool showHiddenFile();

private:
	Directory* getDir(QString dirfullname);
	QString* getDestName(QString *orgFile);
	
	enum OperationMode{NONE, COPY, MOVE};
	
	bool copy (QString *dep, QString *dest);
	bool move (QString *dep, QString *dest);
	void copyNext();
	void moveNext();
	
	bool trash, del, shred;
	bool __showHiddenDir__, __showHiddenFile__;
	bool dropping;

	bool autoSkip;
	bool replaceAll;
	int autoopenTime;
	int totalFiles;

	QString currentItemName;
	QString dirOrg, dirDest;

	OperationMode currentOperation;
	QList<QString>* fileToProcess;
	QString *destDir;


	ImageViewer *iv;
	ImageListeView *imageList;
	MainWindow *mw;

	QTimer *autoopen_timer;
	QListViewItem *dropItem;
	QListViewItem *oldCurrent;

	QProgressDialog *copyProgress;
	QPopupMenu *popup;
	QListViewItem *clickedItem;
	KDirWatch *dirWatch;

	
public slots:
	void startWatchDir(QString);
	void stopWatchDir(QString);

	void startWatchDir();
	void stopWatchDir();

	void slotDirInfo();
	void slotDirProperty();

	void slotShowItem (QListViewItem * item);
	void openFolder ();

	void slotNew (QListViewItem *item);
	void slotNew ();
	void slotSuppr (QListViewItem *item);
	void slotSuppr ();
	void slotTrash (QListViewItem *item);
	void slotTrash ();
	void slotRename (QListViewItem *item);
	void slotRename ();
	void slotDirPasteFiles();

	void triggerUpdate ();
	void updateContents ();

	void slotDirCopy();
	void slotDirMove();
  
protected slots:
	void copyingDone( KIO::Job *);
	void movingDone( KIO::Job *);
	void renameDone( KIO::Job *);

	void copyingDirDone( KIO::Job *);
	void movingDirDone( KIO::Job *);	
	
protected:
	QString shrinkdn(QString str);
	
};
#endif
