/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DESCRIBEALBUM_H__
#define __DESCRIBEALBUM_H__

#include "imagefileinfo.h"

#include <qvariant.h>
#include <kdialog.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QGroupBox;
class QLabel;
class QLineEdit;
class QMultiLineEdit;
class QPushButton;

class ImageFileInfo;


class DescribeAlbum : public KDialog
{ 
    Q_OBJECT

public:
    DescribeAlbum( QWidget* parent, QString dirname, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~DescribeAlbum();

protected slots:
    void accept();
    
protected:
    ImageFileInfo *iinfo;

	QHBoxLayout* Layout1;
	QGroupBox* GroupBox2;
    QLabel* TextLabel2_2;
    QLabel* TextLabel6;
    QLineEdit* shortDescr;
    QMultiLineEdit* longDescr;
    QLabel* TextLabel1;
    QLineEdit* title;
    QPushButton* okButton;
    QPushButton* cancelButton;

};

#endif 
