/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __CONFSHOWIMG_H__
#define __CONFSHOWIMG_H__

#include <kdialogbase.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSlider;
class QFrame;
class QButtonGroup;
class KColorButton;

class ConfShowImg : public KDialogBase
{
Q_OBJECT

public:
	ConfShowImg(QWidget *parent);
	virtual ~ConfShowImg();
	
	void initFiling(bool trash, bool del, bool shred);
	void initMiscellaneous(bool storeth, bool smooth, bool sDir, bool sFile);
	void initColor(QColor bgcolor, int gray);
	void initSlideshow(int type, int time);

	QColor getColor();
	int getGrayscale();
	
	bool checkTrash();
	bool checkDelete();
	bool checkShred();
	
	bool getStoreth();
	bool getSmooth();
	bool getShowDir();
	bool getShowFile();
	
	int getSlideshowTime();
	int getSlideshowType();
	
	void setLayout(int l);
	int getLayout();
	
protected slots:
    virtual void slotChangeTime(int);
    virtual void setGrayscale(int);

protected:
	void addPage1();
	void addPage2();
	void addPage3();
	void addPage4();
 	void addPage5();

	QFrame *page1, *page2, *page3, *page4, *page5;
	
	QPixmap *image0	;
    QGroupBox* GroupBox2;
    QSlider* timeSlide;
    QLineEdit* timeLine;
    QLabel* timeLabel;
    QButtonGroup* ButtonGroup3;
    QCheckBox* wraparound;
    QFrame* Line1;
    QRadioButton* backward;
    QRadioButton* random;
    QRadioButton* forward;
    QGroupBox* GroupBox8;
    QCheckBox* trashCheck;
    QCheckBox* deleteCheck;
    QCheckBox* shredCheck;
    QGroupBox* GroupBox13;
    QComboBox* ComboBox1;
    QGroupBox* GroupBox18;
    QCheckBox* storethCheck;
    QCheckBox* sDirCheck;
    QCheckBox* sFileCheck;
    QCheckBox *smoothCheck;
    QLabel* TextLabel4;
    QLineEdit* LineEdit7;
    QButtonGroup* ButtonGroup2;
    QRadioButton* RadioButton5;
    QPushButton* PushButton1;
    QRadioButton* RadioButton4;
    KColorButton* color;
    QGroupBox* GroupBox6;
    QCheckBox* grayCheck;
    QSlider* graySlider;
    QLabel* PixmapLabel1;
    QRadioButton* radioButton_1;
    QRadioButton* radioButton_2;
    QRadioButton* radioButton_3;
    QRadioButton* radioButton_4;
    QRadioButton* radioButton_5;

};

#endif
