/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* compressedimagefile.h */


#ifndef COMPRESSEDIMAGEFILE_H
#define COMPRESSEDIMAGEFILE_H

#include "showimg.h"
#include "compressedfile.h"
#include "fileitem.h"

#include <qdragobject.h>
#include <qdropsite.h>

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qpopupmenu.h>

class CompressedFileItem;
class ImageViewer;

class CompressedImageFileItem:public FileItem
{
public:
	CompressedImageFileItem (QIconView * parent,
	        		 CompressedFileItem * parentDir,
	        		 const char *archive, const char *filename,
	        		 const char *path, ImageViewer * iv);
				 
	~CompressedImageFileItem ();

	QString text (int column) const;
	QString text () const;

	QString fullName ();
	const QPixmap *pixmap (int) const;
	bool suppression ();

	void setSelected (bool s);

private:
	QFile f;
	bool readable;

	QString *filename;
	QString fullname;

	QString full;
	QString *archive;
	ImageViewer *iv;

	QPixmap *p_open;
	QPixmap *p_close;
	QPixmap *p_none;

	CompressedFileItem *parentDir;
};


#endif
