/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "compressedimagefile.h"

#include "zipfile.h"

#include <qfileinfo.h>
#include <qapplication.h>

#include <kprocess.h>
#include <kapp.h>
#include <kiconloader.h>

CompressedImageFileItem::CompressedImageFileItem (QIconView * parent,
						  CompressedFileItem *parentDir,
						  const char *archive,
						  const char *filename,
						  const char *path,
						  ImageViewer * imv):
    FileItem (parent, "/tmp/.qlist"+QString().setNum(getpid())+"/"+getFullName(new QString(archive))+"/" , filename, "tgz"),
    f (filename)
{
	iv = imv;
	readable = TRUE;
	this->parentDir = parentDir;
	this->archive = new QString (archive);
	size = new QString ("ukn");
	this->archive = new QString (archive);
	this->filename = new QString (filename);
	fullname="/tmp/.qlist"+QString().setNum(getpid())+"/"+getFullName(new QString(archive))+"/" + filename;
	extension = new QString (QString(filename).right(3).lower());
	type = new QString ("zip");
	setName("CompressedImageFileItem");
	date=new QString();
}

CompressedImageFileItem::~CompressedImageFileItem ()
{
}

bool
CompressedImageFileItem::suppression ()
{
	QApplication::setOverrideCursor (waitCursor); // this might take time
	ZipFile (*archive, *filename).deleteFile ();
	parentDir->removeImage (this);
	QApplication::restoreOverrideCursor ();       // restore original cursor

	return true;
}

QString
CompressedImageFileItem::fullName ()
{ 
	return fullname;
}

QString
CompressedImageFileItem::text () const
{
	return text (0);
}


QString
CompressedImageFileItem::text (int column) const
{
	
	if (column == 0)
	{
		QString s(f.name ());
		int pos = s.findRev ("/");
		return QString(s.right (s.length () - pos - 1));
	}
	else if (column == 1)
	{
		return (*extension);
	}
	else if (column == 2)
	{
		return (*size);
	}
	else
		return (*type);
}

void
CompressedImageFileItem::setSelected (bool s)
{
	QIconViewItem::setSelected (s);
	if (s)
	{
		QApplication::setOverrideCursor (waitCursor);	  // this might take time
		iv->loadImage ((const char *) ( fullName ()));
		if (nextItem ())
		    {
		      iv-> preloadImage ((const char *)(((FileItem *) (nextItem ()))-> fullName ()));
		    }
		QApplication::restoreOverrideCursor ();   // restore original cursor
	}
	else
	{
	}
}
