/***************************************************************************
                          batchrenamer.cpp  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "batchrenamer.h"
#include <unistd.h>
#include <sys/stat.h>


BatchRenamer::BatchRenamer(ProgressDialog *p)
{
	this->p = p;
}

BatchRenamer::~BatchRenamer()
{
}

void BatchRenamer::processFiles( struct data* files, enum mode m, struct values* val, bool preview = false )
{
	QString tmp;
	int i;
	QFileInfo fi;

	for( i = 0; i < files[0].count; i++) 
	{
		tmp = val->text;
		if( m == RENAME ) // final Path = source Path
			files[i].final_path = files[i].source_path;
		else
			files[i].final_path = val->dirname;

		tmp = findOldName( files[i].source, tmp );
		tmp = findOldNameLower( files[i].source, tmp );
		tmp = findNumbers( tmp, val->index, files[0].count, i);

		// Add Extension if necesary
		files[i].final = tmp;
		if( val->extension )
		{
			if( !files[i].extension.isEmpty())
				files[i].final += files[i].extension;
		}
	}
	work( files, m, val, preview );
}


void BatchRenamer::work( struct data * files, enum mode m, struct values * val, bool preview = false )
{
	int i, error = 0;
	QString in, out;

	for( i = 0; i < files[0].count; i++)
	{
	 	 in = files[i].source_path + files[i].source + files[i].extension;
	 	 out = files[i].final_path + files[i].final;

	 	 if(p)
	 	 {
	 	 	p->inc();
	 	 }
	 	 f = new QFile( out );
	 	 if( f->exists())
	 	 {
	 	 	 if(!val->overwrite)
	 	 	 {
	 	 	 	 error++;
	 	 	 	 delete f;
	 	 	 	 continue;
	 	 	 }
	 	 }
	 	 else
	 	 	delete f;
	 	 	 
	 	 	 
	 	 if(!preview)
	 	 {
	 	 	 if( m == RENAME || m == MOVE )
	 	 	 {
	 	 	 	 if(!rename( (const char *)in, (const char *)out))
	 	 	 	 	;
	 	 	 	 else
	 	 	 	 {
	 	 	 	 	error++;
	 	 	 	 }
	 	 	 }
	 	 	 else
	 	 	 if( m == COPY )
	 	 	 	if(!fcopy( (const char *)in, (const char *)out ))
	 	 	 		error++;

	 	 	 if( val->dvals.bDate )
	 	 	 {
	 	 		if(!changeDate( out, val->dvals ))
	 	 	 		error++;
	 	 	 }
	 	 }
	}
}

bool BatchRenamer::fcopy( const char* src, const char* dest )
{
	FILE* s;
	FILE* d;
	int c;

	d = fopen(dest, "w");
	if( d == NULL ) 
	{
		return false;
	}

	s = fopen(src, "r");
	if( s == NULL ) 
	{
		return false;
	}

	while(( c = getc( s )) != EOF )
		putc( c, d );

	fclose( s );
	fclose( d );
	return true;
}

int BatchRenamer::getCharacters( int n )
{
	QString s;
	s.sprintf( "%i", n );
	return s.length();
}

QString BatchRenamer::findOldName( QString oldname, QString text )
{
	int num, pos, z;

	num = text.contains("$", FALSE);
	if(num >= 0 ) 
	{
		pos = -1;
		for(z = 0; z < num + 1; z++) 
		{
			pos = text.findRev("$", pos);
			if( pos >= 0 )
				text.replace( pos, 1, oldname);
		}
	}
	return text;
}

QString BatchRenamer::findOldNameLower( QString oldname, QString text )
{
	int num, pos, z;

	num = text.contains("%", FALSE);
	if(num >= 0 ) 
	{
		pos = -1;
		for(z = 0; z < num + 1; z++) 
		{
			pos = text.findRev("%", pos);

			if( pos >= 0 )
				text.replace( pos, 1, oldname.lower());
		}
	}
	return text;
}

QString BatchRenamer::findNumbers( QString text, int index, int count, int i)
{
	// Rewritten in Version 0.8
	QString temp;
	int num, pos = 0, counter = 1;

	num = text.contains( "#", FALSE );
	// Not really neccessary ;)
	if( num <= 0 )
		return text;

	pos = text.find("#", pos);
	pos++;
	while( text[pos] == '#' ) 
	{
		text.remove(pos, 1);
		counter++;
	}

	pos = text.find("#", 0);
	if( pos >= 0 ) 
	{
	 	temp.sprintf("%0*i", counter, index + i );
	 	text.replace( pos, 1, temp);
	}

	return findNumbers( text, index, count, i);
}


bool BatchRenamer::changeDate( QString file, struct datevals dvals )
{
	FILE * f;
	struct utimbuf * t = new utimbuf();
	struct tm tmp;
	struct stat st;

	time_t ti;

	f = fopen((const char *)file, "r");
	if( f == NULL ) 
	{
		return false;
	}

	fclose( f );

	tmp.tm_mday = dvals.date.day();
	tmp.tm_mon = dvals.date.month() - 1;
	tmp.tm_year = dvals.date.year() - 1900;

	tmp.tm_hour = dvals.hour;
	tmp.tm_min = dvals.minute;
	tmp.tm_sec = dvals.second;
	tmp.tm_isdst = -1;

	ti = mktime( &tmp );
	if( ti == -1 ) 
	{
		return false;
	}

	if( stat( (const char *)file, &st ) == -1 ) 
	{
		return false;
	}

	if(dvals.changeAccess)
		t->actime = ti;
	else
		t->actime = st.st_atime;

	if(dvals.changeModification)
		t->modtime = ti;
	else
		t->modtime = st.st_mtime;

	if(utime( (const char *)file, t ) != 0) 
	{
		return false;
	}

	return true;
}

