

/*
  Since it seems like gnome2 refuses to display stdout & stderr for applets,
  this is code for making a window that you can do your normal debug printf to,
  using dprintf instead. 
  Notice that at the moment only %s, %d, %c, %x, %X are supported. (%f is missing!!)

    This piece of code is only used in development. So don't look at it
    too much, since in the release versions of Sherman's aquarium, it isn't
    even compiled.

*/


/* Somehow the gtk_text_* seems to need this one set. 
   Don't ask me why. Maybe some lefts over from the unstable develop series?
*/
#define GTK_ENABLE_BROKEN

#include <gtk/gtk.h>
#include <stdarg.h>



GtkWidget *debug_window, *debug_field;
GdkFont *fixed_font;

int debug_window_exists=0;

/* Quite much of the debug window stuff is taken from the gtk+ text example */ 
void close_debug_window(GtkWidget *a, gpointer *d)
{
  debug_window=0;
  gtk_widget_destroy(debug_window);

}

void make_debug_window()
{
  GtkWidget *box, *table, *scrollbar;

  debug_window_exists=1;

  debug_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request(debug_window, 300, 200);
  gtk_window_set_policy(GTK_WINDOW(debug_window), TRUE, TRUE, FALSE);
  g_signal_connect (G_OBJECT(debug_window), "destroy", G_CALLBACK(close_debug_window), NULL);
  gtk_window_set_title(GTK_WINDOW (debug_window), "Debug Window");

  box=gtk_vbox_new (FALSE,0);
  table = gtk_table_new(2, 2, FALSE); 
  gtk_box_pack_start(GTK_BOX(box), table, TRUE, TRUE, 0);
  gtk_container_add(GTK_CONTAINER(debug_window), box);
  


  debug_field = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(debug_field), FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(debug_field),TRUE);

  gtk_table_attach (GTK_TABLE (table), debug_field, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);


  scrollbar = gtk_vscrollbar_new (GTK_TEXT(debug_field)->vadj);
  gtk_table_attach (GTK_TABLE (table), scrollbar, 1, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);


  fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");

  gtk_widget_show_all(debug_window);

}
void dprintf(const char *fmt, ...)
{
  va_list ap;
  char *buff, c,*s;
  int d,i,ptr=0;

  buff=g_malloc0(1025);
  va_start(ap,fmt);

  if(!debug_window_exists)
    make_debug_window();

  for(i=0;i<strlen(fmt);i++){

    if(fmt[i]=='%'){
      switch(fmt[i+1]){
      case 's':
	s = va_arg(ap, char *);
	g_snprintf(buff+ptr,1024-ptr,"%s", s);
	ptr=strlen(buff);
	break;
      case 'd':
	d = va_arg(ap, int);
	g_snprintf(buff+ptr,1024-ptr,"%d", d);
	ptr=strlen(buff);
	break;
      case 'c':
	c = (char) va_arg(ap, int);
	g_snprintf(buff+ptr,1024-ptr,"%c", c);
	ptr=strlen(buff);
	break;

      case 'x':
	d = va_arg(ap, int);
	g_snprintf(buff+ptr,1024-ptr,"%x", d);
	ptr=strlen(buff);
	break;

      case 'X':
	d = va_arg(ap, int);
	g_snprintf(buff+ptr,1024-ptr,"%X", d);
	ptr=strlen(buff);
	break;
      default:
	break;
	
      }
      i++;
    }
    else{
      g_snprintf(buff+ptr,1024-ptr,"%c", fmt[i]);
      ptr=strlen(buff);
    }
  }

  gtk_text_insert (GTK_TEXT (debug_field), fixed_font, NULL,
		   NULL, buff, strlen(buff));
  
  gtk_text_thaw(GTK_TEXT(debug_field));

  gtk_widget_show(debug_field);
  g_free(buff);
  va_end(ap);

}
