#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: seqan_tcoffee
class: CommandLineTool
cwlVersion: v1.0
doc: "SeqAn::T-Coffee is a multiple sequence alignment tool.\n(c) Copyright 2009 by\
  \ Tobias Rausch\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: Name of multi-fasta input file.
  id: param_seq
  inputBinding:
    prefix: -seq
  label: Name of multi-fasta input file.
  type:
  - 'null'
  - File
- default: protein
  doc: The used sequence alphabet.
  id: param_alphabet
  inputBinding:
    prefix: -alphabet
  label: The used sequence alphabet.
  type:
  - 'null'
  - string
- default: out.fasta
  doc: Filename for outfile output file
  id: param_outfile_filename
  inputBinding:
    prefix: -outfile
  label: Filename for outfile output file
  type:
  - 'null'
  - string
- default: "['global', 'local']"
  doc: 'Defines the generation method for matches. To select multiple generation methods
    recall this option with different arguments. '
  id: param_method
  inputBinding:
    prefix: -method
  label: 'Defines the generation method for matches. To select multiple generation
    methods recall this option with different arguments. '
  type:
  - 'null'
  - string
- doc: Name of match file. To select multiple files recall this option with different
    arguments.
  id: param_libraries
  inputBinding:
    prefix: -libraries
  label: Name of match file. To select multiple files recall this option with different
    arguments.
  type:
  - 'null'
  - File
- doc: 'Pairwise alignment method. Default: unbanded for usual alignments (< 50 sequences),
    banded for deep alignments (>= 50 sequences)'
  id: param_pairwise-alignment
  inputBinding:
    prefix: -pairwise-alignment
  label: 'Pairwise alignment method. Default: unbanded for usual alignments (< 50
    sequences), banded for deep alignments (>= 50 sequences)'
  type:
  - 'null'
  - string
- default: '60'
  doc: Band width. This option automatically select banded pairwise alignment (see
    pa for details)
  id: param_band-width
  inputBinding:
    prefix: -band-width
  label: Band width. This option automatically select banded pairwise alignment (see
    pa for details)
  type:
  - 'null'
  - int
- default: '-13'
  doc: gap open penalty
  id: param_gop
  inputBinding:
    prefix: -gop
  label: gap open penalty
  type:
  - 'null'
  - int
- default: '-1'
  doc: gap extension penalty
  id: param_gex
  inputBinding:
    prefix: -gex
  label: gap extension penalty
  type:
  - 'null'
  - int
- default: Blosum62
  doc: score matrix
  id: param_matrix
  inputBinding:
    prefix: -matrix
  label: score matrix
  type:
  - 'null'
  - string
- default: '5'
  doc: match score
  id: param_msc
  inputBinding:
    prefix: -msc
  label: match score
  type:
  - 'null'
  - int
- default: '-4'
  doc: mismatch penalty
  id: param_mmsc
  inputBinding:
    prefix: -mmsc
  label: mismatch penalty
  type:
  - 'null'
  - int
- doc: Name of the file containing the Newick Guide Tree.
  id: param_usetree
  inputBinding:
    prefix: -usetree
  label: Name of the file containing the Newick Guide Tree.
  type:
  - 'null'
  - string
- default: nj
  doc: 'Method to build the tree. Following methods are provided: Neighbor-Joining
    (nj), UPGMA single linkage (min), UPGMA complete linkage (max), UPGMA average
    linkage (avg), UPGMA weighted average linkage (wavg). Neighbor-Joining creates
    an unrooted tree, which we root at the last joined pair.'
  id: param_build
  inputBinding:
    prefix: -build
  label: 'Method to build the tree. Following methods are provided: Neighbor-Joining
    (nj), UPGMA single linkage (min), UPGMA complete linkage (max), UPGMA average
    linkage (avg), UPGMA weighted average linkage (wavg). Neighbor-Joining creates
    an unrooted tree, which we root at the last joined pair.'
  type:
  - 'null'
  - string
- doc: Name of the alignment file <FASTA FILE>
  id: param_infile
  inputBinding:
    prefix: -infile
  label: Name of the alignment file <FASTA FILE>
  type:
  - 'null'
  - File
label: Multiple sequence alignment
outputs:
- doc: Name of the output file.
  id: param_outfile
  label: Name of the output file.
  outputBinding:
    glob: $(inputs.param_outfile_filename)
  type:
  - 'null'
  - File
