#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_variator
class: CommandLineTool
cwlVersion: v1.0
doc: "Either simulate variation and write out the result to VCF and optionally FASTA\
  \ files.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- default: '0'
  doc: The seed to use for the random number generator.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: The seed to use for the random number generator.
  type:
  - 'null'
  - int
- doc: FASTA file with reference.
  id: param_in-reference
  inputBinding:
    prefix: -in-reference
  label: FASTA file with reference.
  type: File
- doc: TSV file with variants to simulate.  See Section on the Variant TSV File below.
  id: param_in-variant-tsv
  inputBinding:
    prefix: -in-variant-tsv
  label: TSV file with variants to simulate.  See Section on the Variant TSV File
    below.
  type:
  - 'null'
  - File
- doc: VCF file to write simulated variations to.
  id: param_out-vcf
  inputBinding:
    prefix: -out-vcf
  label: VCF file to write simulated variations to.
  type: File
- doc: FASTA file to write simulated haplotypes to.
  id: param_out-fasta
  inputBinding:
    prefix: -out-fasta
  label: FASTA file to write simulated haplotypes to.
  type:
  - 'null'
  - File
- doc: Filename for out-breakpoints output file
  id: param_out-breakpoints_filename
  inputBinding:
    prefix: -out-breakpoints
  label: Filename for out-breakpoints output file
  type:
  - 'null'
  - string
- default: /
  doc: Haplotype name separator in output FASTA.
  id: param_haplotype-name-sep
  inputBinding:
    prefix: -haplotype-name-sep
  label: Haplotype name separator in output FASTA.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Do not generate variant ids.
  id: param_no-gen-var-ids
  inputBinding:
    prefix: -no-gen-var-ids
  label: Do not generate variant ids.
  type:
  - 'null'
  - string
- default: '1'
  doc: The number of haplotypes to simulate.
  id: param_num-haplotypes
  inputBinding:
    prefix: -num-haplotypes
  label: The number of haplotypes to simulate.
  type:
  - 'null'
  - int
- default: /
  doc: The separator between the chromosome and the haplotype name in the output FASTA
    file.
  id: param_haplotype-sep
  inputBinding:
    prefix: -haplotype-sep
  label: The separator between the chromosome and the haplotype name in the output
    FASTA file.
  type:
  - 'null'
  - string
- default: '0.0001'
  doc: Per-base SNP rate.
  id: param_snp-rate
  inputBinding:
    prefix: -snp-rate
  label: Per-base SNP rate.
  type:
  - 'null'
  - double
- default: '1e-06'
  doc: Small indel rate.
  id: param_small-indel-rate
  inputBinding:
    prefix: -small-indel-rate
  label: Small indel rate.
  type:
  - 'null'
  - double
- default: '1'
  doc: Minimal small indel size to simulate.
  id: param_min-small-indel-size
  inputBinding:
    prefix: -min-small-indel-size
  label: Minimal small indel size to simulate.
  type:
  - 'null'
  - int
- default: '6'
  doc: Maximal small indel size to simulate.
  id: param_max-small-indel-size
  inputBinding:
    prefix: -max-small-indel-size
  label: Maximal small indel size to simulate.
  type:
  - 'null'
  - int
- default: '1e-07'
  doc: Per-base SNP rate.
  id: param_sv-indel-rate
  inputBinding:
    prefix: -sv-indel-rate
  label: Per-base SNP rate.
  type:
  - 'null'
  - double
- default: '1e-07'
  doc: Per-base SNP rate.
  id: param_sv-inversion-rate
  inputBinding:
    prefix: -sv-inversion-rate
  label: Per-base SNP rate.
  type:
  - 'null'
  - double
- default: '1e-07'
  doc: Per-base SNP rate.
  id: param_sv-translocation-rate
  inputBinding:
    prefix: -sv-translocation-rate
  label: Per-base SNP rate.
  type:
  - 'null'
  - double
- default: '1e-07'
  doc: Per-base SNP rate.
  id: param_sv-duplication-rate
  inputBinding:
    prefix: -sv-duplication-rate
  label: Per-base SNP rate.
  type:
  - 'null'
  - double
- default: '50'
  doc: Minimal SV size to simulate.
  id: param_min-sv-size
  inputBinding:
    prefix: -min-sv-size
  label: Minimal SV size to simulate.
  type:
  - 'null'
  - int
- default: '1000'
  doc: Maximal SV size to simulate.
  id: param_max-sv-size
  inputBinding:
    prefix: -max-sv-size
  label: Maximal SV size to simulate.
  type:
  - 'null'
  - int
- default: 'false'
  doc: Enable methylation level simulation.
  id: param_methylation-levels
  inputBinding:
    prefix: -methylation-levels
  label: Enable methylation level simulation.
  type:
  - 'null'
  - string
- default: '0.6'
  doc: Median of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-mu
  inputBinding:
    prefix: -meth-cg-mu
  label: Median of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.03'
  doc: Standard deviation of beta distribution for methylation level of CpG loci.
  id: param_meth-cg-sigma
  inputBinding:
    prefix: -meth-cg-sigma
  label: Standard deviation of beta distribution for methylation level of CpG loci.
  type:
  - 'null'
  - double
- default: '0.08'
  doc: Median of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-mu
  inputBinding:
    prefix: -meth-chg-mu
  label: Median of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.008'
  doc: Standard deviation of beta distribution for methylation level of CHG loci.
  id: param_meth-chg-sigma
  inputBinding:
    prefix: -meth-chg-sigma
  label: Standard deviation of beta distribution for methylation level of CHG loci.
  type:
  - 'null'
  - double
- default: '0.05'
  doc: Median of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-mu
  inputBinding:
    prefix: -meth-chh-mu
  label: Median of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
- default: '0.005'
  doc: Standard deviation of beta distribution for methylation level of CHH loci.
  id: param_meth-chh-sigma
  inputBinding:
    prefix: -meth-chh-sigma
  label: Standard deviation of beta distribution for methylation level of CHH loci.
  type:
  - 'null'
  - double
- doc: Path to load original methylation levels from.  Methylation levels are simulated
    if omitted.
  id: param_meth-fasta-in
  inputBinding:
    prefix: -meth-fasta-in
  label: Path to load original methylation levels from.  Methylation levels are simulated
    if omitted.
  type:
  - 'null'
  - File
- doc: Filename for meth-fasta-out output file
  id: param_meth-fasta-out_filename
  inputBinding:
    prefix: -meth-fasta-out
  label: Filename for meth-fasta-out output file
  type:
  - 'null'
  - string
label: Variation Simulation
outputs:
- doc: TSV file to write breakpoints in variants to.
  id: param_out-breakpoints
  label: TSV file to write breakpoints in variants to.
  outputBinding:
    glob: $(inputs.param_out-breakpoints_filename)
  type:
  - 'null'
  - File
- doc: Path to write methylation levels to as FASTA.  Only written if -of/--out-fasta
    is given.
  id: param_meth-fasta-out
  label: Path to write methylation levels to as FASTA.  Only written if -of/--out-fasta
    is given.
  outputBinding:
    glob: $(inputs.param_meth-fasta-out_filename)
  type:
  - 'null'
  - File
