#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: mason_genome
class: CommandLineTool
cwlVersion: v1.0
doc: "Simulate a random genome to the output file.  For each -l/--contig-length entry,\
  \ a contig with the given length will be simulated.\n\n\n\nFor more information,\
  \ visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- doc: Length of the contig to simulate. Give one -l value for each contig to simulate.
  id: param_contig-length
  inputBinding:
    prefix: -contig-length
  label: Length of the contig to simulate. Give one -l value for each contig to simulate.
  type: int
- default: '0'
  doc: The seed to use for the random number generator.
  id: param_seed
  inputBinding:
    prefix: -seed
  label: The seed to use for the random number generator.
  type:
  - 'null'
  - int
- doc: Filename for out-file output file
  id: param_out-file_filename
  inputBinding:
    prefix: -out-file
  label: Filename for out-file output file
  type: string
label: Random Genome Simulation
outputs:
- doc: Output file.
  id: param_out-file
  label: Output file.
  outputBinding:
    glob: $(inputs.param_out-file_filename)
  type: File
