 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ============================================================================
  $Id: score_matrix_data.h 1723 2008-02-11 12:33:52Z rausch@PCPOOL.MI.FU-BERLIN.DE $
 ==========================================================================*/

#ifndef SEQAN_HEADER_SCORE_MATRIX_DATA_H
#define SEQAN_HEADER_SCORE_MATRIX_DATA_H



namespace SEQAN_NAMESPACE_MAIN
{
//////////////////////////////////////////////////////////////////////////////

/**
.Shortcut.Blosum62:
..cat:Scoring
..summary:Blosum62 scoring matrix.
..signature:Blosum62
..remarks.text:This class is a shortcut for @Spec.Score Matrix|Score<int, ScoreMatrix<AminoAcid, _Blosum62> >@.
*/

struct _Blosum62{};
typedef Score<int, ScoreMatrix<AminoAcid, _Blosum62> > Blosum62;

template <>
struct _ScoringMatrixData<int, AminoAcid, _Blosum62>
{
	enum
	{
		VALUE_SIZE = ValueSize<AminoAcid>::VALUE,
		TAB_SIZE = VALUE_SIZE * VALUE_SIZE
	};
	static inline int const * getData()
	{
		static int const _data[TAB_SIZE] = 
		{       
		4, -1, -2, -2,  0, -1, -1,  0, -2, -1, -1, -1, -1, -2, -1,  1,  0, -3, -2,  0, -2, -1,  0, -4,
		-1,  5,  0, -2, -3,  1,  0, -2,  0, -3, -2,  2, -1, -3, -2, -1, -1, -3, -2, -3, -1,  0, -1, -4,
		-2,  0,  6,  1, -3,  0,  0,  0,  1, -3, -3,  0, -2, -3, -2,  1,  0, -4, -2, -3,  3,  0, -1, -4,
		-2, -2,  1,  6, -3,  0,  2, -1, -1, -3, -4, -1, -3, -3, -1,  0, -1, -4, -3, -3,  4,  1, -1, -4,
		0, -3, -3, -3,  9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4,
		-1,  1,  0,  0, -3,  5,  2, -2,  0, -3, -2,  1,  0, -3, -1,  0, -1, -2, -1, -2,  0,  3, -1, -4,
		-1,  0,  0,  2, -4,  2,  5, -2,  0, -3, -3,  1, -2, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4,
		0, -2,  0, -1, -3, -2, -2,  6, -2, -4, -4, -2, -3, -3, -2,  0, -2, -2, -3, -3, -1, -2, -1, -4,
		-2,  0,  1, -1, -3,  0,  0, -2,  8, -3, -3, -1, -2, -1, -2, -1, -2, -2,  2, -3,  0,  0, -1, -4,
		-1, -3, -3, -3, -1, -3, -3, -4, -3,  4,  2, -3,  1,  0, -3, -2, -1, -3, -1,  3, -3, -3, -1, -4,
		-1, -2, -3, -4, -1, -2, -3, -4, -3,  2,  4, -2,  2,  0, -3, -2, -1, -2, -1,  1, -4, -3, -1, -4,
		-1,  2,  0, -1, -3,  1,  1, -2, -1, -3, -2,  5, -1, -3, -1,  0, -1, -3, -2, -2,  0,  1, -1, -4,
		-1, -1, -2, -3, -1,  0, -2, -3, -2,  1,  2, -1,  5,  0, -2, -1, -1, -1, -1,  1, -3, -1, -1, -4,
		-2, -3, -3, -3, -2, -3, -3, -3, -1,  0,  0, -3,  0,  6, -4, -2, -2,  1,  3, -1, -3, -3, -1, -4,
		-1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4,  7, -1, -1, -4, -3, -2, -2, -1, -2, -4,
		1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -2,  0, -1, -2, -1,  4,  1, -3, -2, -2,  0,  0,  0, -4,
		0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1,  1,  5, -2, -2,  0, -1, -1,  0, -4,
		-3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1,  1, -4, -3, -2, 11,  2, -3, -4, -3, -2, -4,
		-2, -2, -2, -3, -2, -1, -2, -3,  2, -1, -1, -2, -1,  3, -3, -2, -2,  2,  7, -1, -3, -2, -1, -4,
		0, -3, -3, -3, -1, -2, -2, -3, -3,  3,  1, -2,  1, -1, -2, -2,  0, -3, -1,  4, -3, -2, -1, -4,
		-2, -1,  3,  4, -3,  0,  1, -1,  0, -3, -4,  0, -3, -3, -2,  0, -1, -4, -3, -3,  4,  1, -1, -4,
		-1,  0,  0,  1, -3,  3,  4, -2,  0, -3, -3,  1, -1, -3, -1,  0, -1, -3, -2, -2,  1,  4, -1, -4,
		0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,  0,  0, -2, -1, -1, -1, -1, -1, -4,
		-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,  1
		};
		return _data;
	}

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////

/**
.Shortcut.Blosum30:
..cat:Scoring
..summary:Blosum30 scoring matrix.
..signature:Blosum30
..remarks.text:This class is a shortcut for @Spec.Score Matrix|Score<int, ScoreMatrix<AminoAcid, _Blosum30> >@.
*/

struct _Blosum30{};
typedef Score<int, ScoreMatrix<AminoAcid, _Blosum30> > Blosum30;

template <>
struct _ScoringMatrixData<int, AminoAcid, _Blosum30>
{
	enum
	{
		VALUE_SIZE = ValueSize<AminoAcid>::VALUE,
		TAB_SIZE = VALUE_SIZE * VALUE_SIZE
	};
	static inline int const * getData()
	{
		static int const _data[TAB_SIZE] = 
		{       
4,0,-3,0,0,-2,0,-2,0,0,-1,1,0,-1,1,-1,1,1,1,-5,0,-4,0,-7,              
0,5,-2,5,0,-3,0,-2,-2,0,-1,-2,4,-2,-1,-2,0,0,-2,-5,-1,-3,0,-7,         
-3,-2,17,-3,1,-3,-4,-5,-2,-3,0,-2,-1,-3,-2,-2,-2,-2,-2,-2,-2,-6,0,-7,  
0,5,-3,9,1,-5,-1,-2,-4,0,-1,-3,1,-1,-1,-1,0,-1,-2,-4,-1,-1,0,-7,       
0,0,1,1,6,-4,-2,0,-3,2,-1,-1,-1,1,2,-1,0,-2,-3,-1,-1,-2,5,-7,          
                                                                       
-2,-3,-3,-5,-4,10,-3,-3,0,-1,2,-2,-1,-4,-3,-1,-1,-2,1,1,-1,3,-4,-7,    
0,0,-4,-1,-2,-3,8,-3,-1,-1,-2,-2,0,-1,-2,-2,0,-2,-3,1,-1,-3,-2,-7,     
-2,-2,-5,-2,0,-3,-3,14,-2,-2,-1,2,-1,1,0,-1,-1,-2,-3,-5,-1,0,0,-7,     
0,-2,-2,-4,-3,0,-1,-2,6,-2,2,1,0,-3,-2,-3,-1,0,4,-3,0,-1,-3,-7,        
0,0,-3,0,2,-1,-1,-2,-2,4,-2,2,0,1,0,1,0,-1,-2,-2,0,-1,1,-7,            
                                                                       
-1,-1,0,-1,-1,2,-2,-1,2,-2,4,2,-2,-3,-2,-2,-2,0,1,-2,0,3,-1,-7,        
1,-2,-2,-3,-1,-2,-2,2,1,2,2,6,0,-4,-1,0,-2,0,0,-3,0,-1,-1,-7,          
0,4,-1,1,-1,-1,0,-1,0,0,-2,0,8,-3,-1,-2,0,1,-2,-7,0,-4,-1,-7,          
-1,-2,-3,-1,1,-4,-1,1,-3,1,-3,-4,-3,11,0,-1,-1,0,-4,-3,-1,-2,0,-7,     
1,-1,-2,-1,2,-3,-2,0,-2,0,-2,-1,-1,0,8,3,-1,0,-3,-1,0,-1,4,-7,         
                                                                       
-1,-2,-2,-1,-1,-1,-2,-1,-3,1,-2,0,-2,-1,3,8,-1,-3,-1,0,-1,0,0,-7,      
1,0,-2,0,0,-1,0,-1,-1,0,-2,-2,0,-1,-1,-1,4,2,-1,-3,0,-2,-1,-7,         
1,0,-2,-1,-2,-2,-2,-2,0,-1,0,0,1,0,0,-3,2,5,1,-5,0,-1,-1,-7,           
1,-2,-2,-2,-3,1,-3,-3,4,-2,1,0,-2,-4,-3,-1,-1,1,5,-3,0,1,-3,-7,        
-5,-5,-2,-4,-1,1,1,-5,-3,-2,-2,-3,-7,-3,-1,0,-3,-5,-3,20,-2,5,-1,-7,   
                                                                       
0,-1,-2,-1,-1,-1,-1,-1,0,0,0,0,0,-1,0,-1,0,0,0,-2,-1,-1,0,-7,          
-4,-3,-6,-1,-2,3,-3,0,-1,-1,3,-1,-4,-2,-1,0,-2,-1,1,5,-1,9,-2,-7,      
0,0,0,0,5,-4,-2,0,-3,1,-1,-1,-1,0,4,0,-1,-1,-3,-1,0,-2,4,-7,           
-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,1
		};
		return _data;
	}

};
		

//////////////////////////////////////////////////////////////////////////////

/**
.Shortcut.Blosum80:
..cat:Scoring
..summary:Blosum80 scoring matrix.
..signature:Blosum80
..remarks.text:This class is a shortcut for @Spec.Score Matrix|Score<int, ScoreMatrix<AminoAcid, _Blosum80> >@.
*/

struct _Blosum80{};
typedef Score<int, ScoreMatrix<AminoAcid, _Blosum80> > Blosum80;

template <>
struct _ScoringMatrixData<int, AminoAcid, _Blosum80>
{
	enum
	{
		VALUE_SIZE = ValueSize<AminoAcid>::VALUE,
		TAB_SIZE = VALUE_SIZE * VALUE_SIZE
	};
	static inline int const * getData()
	{
		static int const _data[TAB_SIZE] = 
		{
7,-3,-1,-3,-2,-4,0,-3,-3,-1,-3,-2,-3,-1,-2,-3,2,0,-1,-5,-1,-4,-2,-8,     
-3,6,-6,6,1,-6,-2,-1,-6,-1,-7,-5,5,-4,-1,-2,0,-1,-6,-8,-3,-5,0,-8,       
-1,-6,13,-7,-7,-4,-6,-7,-2,-6,-3,-3,-5,-6,-5,-6,-2,-2,-2,-5,-4,-5,-7,-8, 
-3,6,-7,10,2,-6,-3,-2,-7,-2,-7,-6,2,-3,-1,-3,-1,-2,-6,-8,-3,-6,1,-8,     
-2,1,-7,2,8,-6,-4,0,-6,1,-6,-4,-1,-2,3,-1,-1,-2,-4,-6,-2,-5,6,-8,        
                                                                         
-4,-6,-4,-6,-6,10,-6,-2,-1,-5,0,0,-6,-6,-5,-5,-4,-4,-2,0,-3,4,-6,-8,     
0,-2,-6,-3,-4,-6,9,-4,-7,-3,-7,-5,-1,-5,-4,-4,-1,-3,-6,-6,-3,-6,-4,-8,   
-3,-1,-7,-2,0,-2,-4,12,-6,-1,-5,-4,1,-4,1,0,-2,-3,-5,-4,-2,3,0,-8,       
-3,-6,-2,-7,-6,-1,-7,-6,7,-5,2,2,-6,-5,-5,-5,-4,-2,4,-5,-2,-3,-6,-8,     
-1,-1,-6,-2,1,-5,-3,-1,-5,8,-4,-3,0,-2,2,3,-1,-1,-4,-6,-2,-4,1,-8,       
                                                                         
-3,-7,-3,-7,-6,0,-7,-5,2,-4,6,3,-6,-5,-4,-4,-4,-3,1,-4,-2,-2,-5,-8,      
-2,-5,-3,-6,-4,0,-5,-4,2,-3,3,9,-4,-4,-1,-3,-3,-1,1,-3,-2,-3,-3,-8,      
-3,5,-5,2,-1,-6,-1,1,-6,0,-6,-4,9,-4,0,-1,1,0,-5,-7,-2,-4,-1,-8,         
-1,-4,-6,-3,-2,-6,-5,-4,-5,-2,-5,-4,-4,12,-3,-3,-2,-3,-4,-7,-3,-6,-2,-8, 
-2,-1,-5,-1,3,-5,-4,1,-5,2,-4,-1,0,-3,9,1,-1,-1,-4,-4,-2,-3,5,-8,        
                                                                         
-3,-2,-6,-3,-1,-5,-4,0,-5,3,-4,-3,-1,-3,1,9,-2,-2,-4,-5,-2,-4,0,-8,      
2,0,-2,-1,-1,-4,-1,-2,-4,-1,-4,-3,1,-2,-1,-2,7,2,-3,-6,-1,-3,-1,-8,      
0,-1,-2,-2,-2,-4,-3,-3,-2,-1,-3,-1,0,-3,-1,-2,2,8,0,-5,-1,-3,-2,-8,      
-1,-6,-2,-6,-4,-2,-6,-5,4,-4,1,1,-5,-4,-4,-4,-3,0,7,-5,-2,-3,-4,-8,      
-5,-8,-5,-8,-6,0,-6,-4,-5,-6,-4,-3,-7,-7,-4,-5,-6,-5,-5,16,-5,3,-5,-8,   
                                                                         
-1,-3,-4,-3,-2,-3,-3,-2,-2,-2,-2,-2,-2,-3,-2,-2,-1,-1,-2,-5,-2,-3,-1,-8, 
-4,-5,-5,-6,-5,4,-6,3,-3,-4,-2,-3,-4,-6,-3,-4,-3,-3,-3,3,-3,11,-4,-8,    
-2,0,-7,1,6,-6,-4,0,-6,1,-5,-3,-1,-2,5,0,-1,-2,-4,-5,-1,-4,6,-8,         
-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1  
		};
		return _data;
	}

};


}// namespace SEQAN_NAMESPACE_MAIN


#endif //#ifndef SEQAN_HEADER_...

