#!/usr/bin/perl
#
#    newrules.pl.
#
#    
#    Copyright (C) 2001  Justin R. Smith (jsmith@mcs.drexel.edu)
#
#    This program is free software; you can redistribute it and/or 
#    modify
#    it under the terms of the GNU General Public License as published
#    by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA     
#                                        02111-1307  USA
#

# Get the 'access denied' messages
@allmessages=split /\n/,`dmesg`;


my %rules = ();

# format: $rules{ "$scontext|$tcontext|$tclass"}
#          = { '$accesstype' => 1}; 

foreach $inline (@allmessages)
  {
    next unless ($inline =~ m/avc:\s*denied\s*\{((\w|\s)*)\}/);
    my $accesstype = $1;
    my $nextline = $';
    $nextline =~ m/scontext=\w+:\w+:(\w+)\s*/;
    my $scontext = $1;
    $nextline = $';
    $nextline =~ m/tcontext=\w+:\w+:(\w+)\s*/;
    my $tcontext = $1;
    $nextline = $';
    $nextline =~ m/tclass=(\w+)\s*\Z/;
    my $tclass = $1;
    my @atypes = split /\s+/,$accesstype;
    foreach $atype (@atypes)
      {
	next unless $atype =~ m/\S/;
	my $trim=undef;
	$atype =~ m/\s*(\w+)\s*/;
	$trim = $1;
	$rules{"$scontext|$tcontext|$tclass"}{$trim}=1;
      }
  }

# done  with the input file
# now generate the rules

foreach $k (sort keys %rules)
  {
    my ($scontext,$tcontext,$tclass) = split /\|/, $k;
    print  "allow $scontext $tcontext:$tclass { ";
    my $access_types = $rules{$k};
    foreach $t (sort keys %$access_types)
      {
	print  "$t ";
      }
    print  "};\n";
  }
#
